/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.pagebuilder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bremersee.pagebuilder.PageBuilderUtils;
import org.bremersee.pagebuilder.PageEntryTransformer;
import org.bremersee.pagebuilder.model.Page;
import org.bremersee.pagebuilder.model.PageDto;
import org.bremersee.pagebuilder.model.PageRequest;

public class PageResult<E>
implements Page<E> {
    private List<E> entries = new ArrayList();
    private PageRequest pageRequest;
    private long totalSize;

    public PageResult() {
    }

    public PageResult(Collection<? extends E> entries) {
        this(entries, null, 0L);
    }

    public PageResult(Collection<? extends E> entries, long totalSize) {
        this(entries, null, totalSize);
    }

    public PageResult(Collection<? extends E> entries, PageRequest pageRequest, long totalSize) {
        if (entries != null) {
            this.entries.addAll(entries);
        }
        this.setPageRequest(pageRequest);
        this.setTotalSize(totalSize);
    }

    @Override
    public List<E> getEntries() {
        return this.entries;
    }

    public void setEntries(List<E> entries) {
        if (entries == null) {
            entries = new ArrayList();
        }
        this.entries = entries;
    }

    @Override
    public PageRequest getPageRequest() {
        return this.pageRequest;
    }

    public void setPageRequest(PageRequest pageRequest) {
        this.pageRequest = pageRequest;
    }

    @Override
    public long getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    @Override
    public int getTotalPages() {
        if (this.getTotalSize() <= 0L) {
            return 1;
        }
        return (int)Math.ceil((double)this.getTotalSize() / (double)this.getPageRequest().getPageSize());
    }

    public <T> PageDto toPageDto(PageEntryTransformer<T, E> transformer) {
        return PageBuilderUtils.createPageDto(this, transformer);
    }
}

