/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.pagebuilder.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.StringUtils;
import org.bremersee.pagebuilder.model.PageDto;
import org.bremersee.pagebuilder.model.PageRequestLinkDto;
import org.bremersee.pagebuilder.model.PageSizeSelectorOptionDto;
import org.bremersee.pagebuilder.model.PaginationDto;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
@XmlRootElement(name="pageControl")
@XmlType(name="pageControlType", propOrder={"page", "pageRequestLinks", "pageSizeSelectorOptions", "pagination", "querySupported", "queryParamName", "pageNumberParamName", "pageSizeParamName", "comparatorParamName", "comparatorParamValue"})
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.ALWAYS)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC, creatorVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC, setterVisibility=JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC)
@JsonPropertyOrder(value={"page", "pageRequestLinks", "pageSizeSelectorOptions", "pagination", "querySupported", "queryParamName", "pageNumberParamName", "pageSizeParamName", "comparatorParamName", "comparatorParamValue"})
public class PageControlDto
implements Serializable {
    private static final long serialVersionUID = 1L;
    private PageDto page;
    private List<PageRequestLinkDto> pageRequestLinks = new ArrayList<PageRequestLinkDto>();
    private List<PageSizeSelectorOptionDto> pageSizeSelectorOptions = new ArrayList<PageSizeSelectorOptionDto>();
    private PaginationDto pagination;
    private boolean querySupported = true;
    private String queryParamName = "q";
    private String pageNumberParamName = "p";
    private String pageSizeParamName = "s";
    private String comparatorParamName = "c";
    private String comparatorParamValue;

    public PageControlDto() {
    }

    public PageControlDto(PageDto page, PaginationDto pagination, String pageNumberParamName, String pageSizeParamName, List<PageSizeSelectorOptionDto> pageSizeSelectorOptions, String comparatorParamName, String comparatorParamValue, boolean querySupported, String queryParamName) {
        this.page = page;
        this.pagination = pagination;
        this.pageNumberParamName = pageNumberParamName;
        this.pageSizeParamName = pageSizeParamName;
        this.setPageSizeSelectorOptions(pageSizeSelectorOptions);
        this.comparatorParamName = comparatorParamName;
        this.comparatorParamValue = comparatorParamValue;
        this.querySupported = querySupported;
        this.queryParamName = queryParamName;
    }

    public String toString() {
        return "PageControlDto [page=" + this.page + ", pageRequestLinks=" + this.pageRequestLinks + ", pageSizeSelectorOptions=" + this.pageSizeSelectorOptions + ", pagination=" + this.pagination + ", querySupported=" + this.querySupported + ", queryParamName=" + this.queryParamName + ", pageNumberParamName=" + this.pageNumberParamName + ", pageSizeParamName=" + this.pageSizeParamName + ", comparatorParamName=" + this.comparatorParamName + ", comparatorParamValue=" + this.comparatorParamValue + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.comparatorParamName == null ? 0 : this.comparatorParamName.hashCode());
        result = 31 * result + (this.comparatorParamValue == null ? 0 : this.comparatorParamValue.hashCode());
        result = 31 * result + (this.page == null ? 0 : this.page.hashCode());
        result = 31 * result + (this.pageNumberParamName == null ? 0 : this.pageNumberParamName.hashCode());
        result = 31 * result + (this.pageRequestLinks == null ? 0 : this.pageRequestLinks.hashCode());
        result = 31 * result + (this.pageSizeParamName == null ? 0 : this.pageSizeParamName.hashCode());
        result = 31 * result + (this.pageSizeSelectorOptions == null ? 0 : this.pageSizeSelectorOptions.hashCode());
        result = 31 * result + (this.pagination == null ? 0 : this.pagination.hashCode());
        result = 31 * result + (this.queryParamName == null ? 0 : this.queryParamName.hashCode());
        result = 31 * result + (this.querySupported ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageControlDto other = (PageControlDto)obj;
        if (this.comparatorParamName == null ? other.comparatorParamName != null : !this.comparatorParamName.equals(other.comparatorParamName)) {
            return false;
        }
        if (this.comparatorParamValue == null ? other.comparatorParamValue != null : !this.comparatorParamValue.equals(other.comparatorParamValue)) {
            return false;
        }
        if (this.page == null ? other.page != null : !this.page.equals(other.page)) {
            return false;
        }
        if (this.pageNumberParamName == null ? other.pageNumberParamName != null : !this.pageNumberParamName.equals(other.pageNumberParamName)) {
            return false;
        }
        if (this.pageRequestLinks == null ? other.pageRequestLinks != null : !this.pageRequestLinks.equals(other.pageRequestLinks)) {
            return false;
        }
        if (this.pageSizeParamName == null ? other.pageSizeParamName != null : !this.pageSizeParamName.equals(other.pageSizeParamName)) {
            return false;
        }
        if (this.pageSizeSelectorOptions == null ? other.pageSizeSelectorOptions != null : !this.pageSizeSelectorOptions.equals(other.pageSizeSelectorOptions)) {
            return false;
        }
        if (this.pagination == null ? other.pagination != null : !this.pagination.equals(other.pagination)) {
            return false;
        }
        if (this.queryParamName == null ? other.queryParamName != null : !this.queryParamName.equals(other.queryParamName)) {
            return false;
        }
        return this.querySupported == other.querySupported;
    }

    @XmlElement(name="page", required=true)
    @JsonProperty(value="page", required=true)
    public PageDto getPage() {
        return this.page;
    }

    @JsonProperty(value="page", required=true)
    public void setPage(PageDto page) {
        this.page = page;
    }

    @XmlElementWrapper(name="pageRequestLinks", required=false)
    @XmlElement(name="pageRequestLink")
    @JsonProperty(value="pageRequestLinks", required=false)
    public List<PageRequestLinkDto> getPageRequestLinks() {
        return this.pageRequestLinks;
    }

    @JsonProperty(value="pageRequestLinks", required=false)
    public void setPageRequestLinks(List<PageRequestLinkDto> pageRequestLinks) {
        if (pageRequestLinks == null) {
            pageRequestLinks = new ArrayList<PageRequestLinkDto>();
        }
        this.pageRequestLinks = pageRequestLinks;
    }

    @XmlElement(name="pagination", required=false)
    @JsonProperty(value="pagination", required=false)
    public PaginationDto getPagination() {
        return this.pagination;
    }

    @JsonProperty(value="pagination", required=false)
    public void setPagination(PaginationDto pagination) {
        this.pagination = pagination;
    }

    @XmlElement(name="pageNumberParamName", defaultValue="p")
    @JsonProperty(value="pageNumberParamName", required=true)
    public String getPageNumberParamName() {
        return this.pageNumberParamName;
    }

    @JsonProperty(value="pageNumberParamName", required=false)
    public void setPageNumberParamName(String pageNumberParamName) {
        if (StringUtils.isNotBlank((CharSequence)pageNumberParamName)) {
            this.pageNumberParamName = pageNumberParamName;
        }
    }

    @XmlElement(name="pageSizeParamName", defaultValue="s")
    @JsonProperty(value="pageSizeParamName", required=true)
    public String getPageSizeParamName() {
        return this.pageSizeParamName;
    }

    @JsonProperty(value="pageSizeParamName", required=false)
    public void setPageSizeParamName(String pageSizeParamName) {
        if (StringUtils.isNotBlank((CharSequence)pageSizeParamName)) {
            this.pageSizeParamName = pageSizeParamName;
        }
    }

    @XmlElementWrapper(name="pageSizeSelectorOptions", required=false)
    @XmlElement(name="pageSizeSelectorOption")
    @JsonProperty(value="pageSizeSelectorOptions", required=false)
    public List<PageSizeSelectorOptionDto> getPageSizeSelectorOptions() {
        return this.pageSizeSelectorOptions;
    }

    @JsonProperty(value="pageSizeSelectorOptions", required=false)
    public void setPageSizeSelectorOptions(List<PageSizeSelectorOptionDto> pageSizeSelectorOptions) {
        if (pageSizeSelectorOptions == null) {
            pageSizeSelectorOptions = new ArrayList<PageSizeSelectorOptionDto>();
        }
        this.pageSizeSelectorOptions = pageSizeSelectorOptions;
    }

    @XmlElement(name="comparatorParamName", defaultValue="c")
    @JsonProperty(value="comparatorParamName", required=true)
    public String getComparatorParamName() {
        return this.comparatorParamName;
    }

    @JsonProperty(value="comparatorParamName", required=false)
    public void setComparatorParamName(String comparatorParamName) {
        if (StringUtils.isNotBlank((CharSequence)comparatorParamName)) {
            this.comparatorParamName = comparatorParamName;
        }
    }

    @XmlElement(name="comparatorParamValue", required=false)
    @JsonProperty(value="comparatorParamValue", required=false)
    public String getComparatorParamValue() {
        return this.comparatorParamValue;
    }

    @JsonProperty(value="comparatorParamValue", required=false)
    public void setComparatorParamValue(String comparatorParamValue) {
        this.comparatorParamValue = comparatorParamValue;
    }

    @XmlElement(name="querySupported", defaultValue="true")
    @JsonProperty(value="querySupported", required=true)
    public boolean isQuerySupported() {
        return this.querySupported;
    }

    @JsonProperty(value="querySupported", required=false)
    public void setQuerySupported(boolean querySupported) {
        this.querySupported = querySupported;
    }

    @XmlElement(name="queryParamName", defaultValue="q")
    @JsonProperty(value="queryParamName", required=true)
    public String getQueryParamName() {
        return this.queryParamName;
    }

    @JsonProperty(value="queryParamName", required=false)
    public void setQueryParamName(String queryParamName) {
        if (StringUtils.isNotBlank((CharSequence)queryParamName)) {
            this.queryParamName = queryParamName;
        }
    }
}

