/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.pagebuilder.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.Validate;
import org.bremersee.comparator.model.ComparatorItem;
import org.bremersee.pagebuilder.model.PageRequest;
import org.bremersee.pagebuilder.model.PageRequestLinkDto;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
@XmlRootElement(name="pageRequest")
@XmlType(name="pageRequestType", propOrder={"pageNumber", "pageSize", "firstResult", "comparatorItem", "query", "extension"})
@XmlSeeAlso(value={PageRequestLinkDto.class})
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.ALWAYS)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC, creatorVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC, setterVisibility=JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC)
@JsonPropertyOrder(value={"pageNumber", "pageSize", "firstResult", "comparatorItem", "query", "extension"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="_type_", visible=true, defaultImpl=PageRequestDto.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=PageRequestDto.class, name="PageRequestDto"), @JsonSubTypes.Type(value=PageRequestLinkDto.class, name="PageRequestLinkDto")})
public class PageRequestDto
implements Serializable,
PageRequest,
Comparable<PageRequest> {
    private static final long serialVersionUID = 1L;
    private int pageNumber = 0;
    private int pageSize = Integer.MAX_VALUE;
    private ComparatorItem comparatorItem;
    private String query;
    private Object extension;

    public PageRequestDto() {
    }

    public PageRequestDto(PageRequest pageRequest) {
        if (pageRequest != null) {
            this.setComparatorItem(pageRequest.getComparatorItem());
            this.setExtension(pageRequest.getExtension());
            this.setPageNumber(pageRequest.getPageNumber());
            this.setPageSize(pageRequest.getPageSize());
            this.setExtension(pageRequest.getExtension());
        }
    }

    public PageRequestDto(int pageNumber, int pageSize) {
        this(pageNumber, pageSize, null, null, null);
    }

    public PageRequestDto(int pageNumber, int pageSize, ComparatorItem comparatorItem) {
        this(pageNumber, pageSize, comparatorItem, null, null);
    }

    public PageRequestDto(int pageNumber, int pageSize, ComparatorItem comparatorItem, String query) {
        this(pageNumber, pageSize, comparatorItem, query, null);
    }

    public PageRequestDto(int pageNumber, int pageSize, ComparatorItem comparatorItem, String query, Object extension) {
        this.setPageNumber(pageNumber);
        this.setPageSize(pageSize);
        this.setComparatorItem(comparatorItem);
        this.setQuery(query);
        this.setExtension(extension);
    }

    public String toString() {
        return "PageRequestDto [pageNumber=" + this.pageNumber + ", pageSize=" + this.pageSize + ", comparatorItem=" + this.comparatorItem + ", query=" + this.query + ", extension=" + this.extension + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.comparatorItem == null ? 0 : this.comparatorItem.hashCode());
        result = 31 * result + (this.extension == null ? 0 : this.extension.hashCode());
        result = 31 * result + this.pageNumber;
        result = 31 * result + this.pageSize;
        result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageRequestDto other = (PageRequestDto)obj;
        if (this.comparatorItem == null ? other.comparatorItem != null : !this.comparatorItem.equals((Object)other.comparatorItem)) {
            return false;
        }
        if (this.extension == null ? other.extension != null : !this.extension.equals(other.extension)) {
            return false;
        }
        if (this.pageNumber != other.pageNumber) {
            return false;
        }
        if (this.pageSize != other.pageSize) {
            return false;
        }
        return !(this.query == null ? other.query != null : !this.query.equals(other.query));
    }

    @Override
    public int compareTo(PageRequest pageRequest) {
        if (pageRequest == null) {
            return -1;
        }
        return this.getPageNumber() - pageRequest.getPageNumber();
    }

    @Override
    @XmlElement(name="pageNumber", required=true)
    @JsonProperty(value="pageNumber", required=true)
    public int getPageNumber() {
        return this.pageNumber;
    }

    @JsonProperty(value="pageNumber", required=true)
    public void setPageNumber(int pageNumber) {
        Validate.isTrue((pageNumber >= 0 ? 1 : 0) != 0, (String)"Page number must be 0 or greater than 0.", (Object[])new Object[0]);
        this.pageNumber = pageNumber;
    }

    @Override
    @XmlElement(name="pageSize", required=true)
    @JsonProperty(value="pageSize", required=true)
    public int getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="pageSize", required=true)
    public void setPageSize(int pageSize) {
        Validate.isTrue((pageSize >= 1 ? 1 : 0) != 0, (String)"Page number must be 1 or greater than 1.", (Object[])new Object[0]);
        this.pageSize = pageSize;
    }

    @Override
    @XmlElement(name="firstResult", required=false)
    @JsonProperty(value="firstResult", required=false)
    public int getFirstResult() {
        long firstResult = (long)this.getPageNumber() * (long)this.getPageSize();
        if (firstResult < Integer.MAX_VALUE) {
            return Long.valueOf(firstResult).intValue();
        }
        return Integer.MAX_VALUE;
    }

    @JsonProperty(value="firstResult", required=false)
    protected void setFirstResult(Integer firstResult) {
    }

    @Override
    @XmlElement(name="comparatorItem", required=false)
    @JsonProperty(value="comparatorItem", required=false)
    public ComparatorItem getComparatorItem() {
        return this.comparatorItem;
    }

    @JsonProperty(value="comparatorItem", required=false)
    public void setComparatorItem(ComparatorItem comparatorItem) {
        this.comparatorItem = comparatorItem;
    }

    @Override
    @XmlElement(name="query", required=false)
    @JsonProperty(value="query", required=false)
    public String getQuery() {
        return this.query;
    }

    @JsonProperty(value="query", required=false)
    public void setQuery(String query) {
        this.query = query;
    }

    @Override
    @XmlAnyElement(lax=true)
    @JsonProperty(value="extension", required=false)
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension", required=false)
    public void setExtension(Object extension) {
        this.extension = extension;
    }
}

