/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.pagebuilder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.bremersee.comparator.ObjectComparatorFactory;
import org.bremersee.pagebuilder.PageBuilder;
import org.bremersee.pagebuilder.PageBuilderFilter;
import org.bremersee.pagebuilder.PageBuilderUtils;
import org.bremersee.pagebuilder.PageEntryTransformer;
import org.bremersee.pagebuilder.PageResult;
import org.bremersee.pagebuilder.model.PageRequest;
import org.bremersee.pagebuilder.model.PageRequestDto;

public class PageBuilderImpl
implements PageBuilder {
    private ObjectComparatorFactory objectComparatorFactory = ObjectComparatorFactory.newInstance();
    private PageBuilderFilter pageBuilderFilter;

    protected ObjectComparatorFactory getObjectComparatorFactory() {
        return this.objectComparatorFactory;
    }

    public void setObjectComparatorFactory(ObjectComparatorFactory objectComparatorFactory) {
        if (objectComparatorFactory != null) {
            this.objectComparatorFactory = objectComparatorFactory;
        }
    }

    protected PageBuilderFilter getPageBuilderFilter() {
        return this.pageBuilderFilter;
    }

    public void setPageBuilderFilter(PageBuilderFilter pageBuilderFilter) {
        this.pageBuilderFilter = pageBuilderFilter;
    }

    public String toString() {
        return "PageBuilderImpl [pageBuilderFilter=" + this.pageBuilderFilter + "]";
    }

    public <E> PageResult<E> buildPage(Iterable<? extends E> pageEntries, PageRequest pageRequest, long totalSize) {
        return this.buildPage((Iterable)pageEntries, pageRequest, totalSize, (PageEntryTransformer)null);
    }

    public <T, E> PageResult<T> buildPage(Iterable<? extends E> pageEntries, PageRequest pageRequest, long totalSize, PageEntryTransformer<T, E> transformer) {
        return PageBuilderUtils.createPage(pageEntries, pageRequest, totalSize, transformer);
    }

    public <E> PageResult<E> buildFilteredPage(Collection<? extends E> allAvailableEntries, PageRequest pageRequest, Object filterCriteria) {
        return this.buildFilteredPage((Collection)allAvailableEntries, pageRequest, filterCriteria, (PageEntryTransformer)null);
    }

    public <T, E> PageResult<T> buildFilteredPage(Collection<? extends E> allAvailableEntries, PageRequest pageRequest, Object filterCriteria, PageEntryTransformer<T, E> transformer) {
        ArrayList<Object> filteredEntries;
        Collection<Object> allAvailEntries = allAvailableEntries == null ? new ArrayList<E>() : allAvailableEntries;
        PageRequest request = pageRequest == null ? new PageRequestDto() : pageRequest;
        ArrayList<E> allEntries = new ArrayList<E>(allAvailEntries);
        if (request.getComparatorItem() != null) {
            Collections.sort(allEntries, this.objectComparatorFactory.newObjectComparator(request.getComparatorItem()));
        }
        if (this.getPageBuilderFilter() == null) {
            filteredEntries = allEntries;
        } else {
            filteredEntries = new ArrayList(allAvailEntries.size());
            for (Object entry : allEntries) {
                if (!this.getPageBuilderFilter().accept(entry, filterCriteria)) continue;
                filteredEntries.add(entry);
            }
        }
        ArrayList<Object> pageEntries = new ArrayList<Object>(filteredEntries.size());
        if (request.getFirstResult() < filteredEntries.size()) {
            int lastResult = request.getFirstResult() + request.getPageSize();
            for (int i = request.getFirstResult(); i < lastResult; ++i) {
                if (i >= filteredEntries.size()) continue;
                if (transformer == null) {
                    pageEntries.add(filteredEntries.get(i));
                    continue;
                }
                pageEntries.add(transformer.transform(filteredEntries.get(i)));
            }
        }
        return new PageResult(pageEntries, request, filteredEntries.size());
    }
}

