/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.pagebuilder;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.Validate;
import org.bremersee.pagebuilder.PageEntryTransformer;
import org.bremersee.pagebuilder.PageResult;
import org.bremersee.pagebuilder.model.Page;
import org.bremersee.pagebuilder.model.PageDto;
import org.bremersee.pagebuilder.model.PageRequest;
import org.bremersee.pagebuilder.model.PageRequestDto;
import org.bremersee.utils.CastUtils;
import org.w3c.dom.Node;

public abstract class PageBuilderUtils {
    private static final ObjectMapper DEFAULT_OBJECT_MAPPER = new ObjectMapper();
    private static final Map<AnnotatedElement, JAXBContext> JAXB_CONTEXTS = new ConcurrentHashMap<AnnotatedElement, JAXBContext>();

    private PageBuilderUtils() {
    }

    private static JAXBContext getJaxbContext(Class<?> valueType) throws JAXBException {
        JAXBContext jaxbContext = JAXB_CONTEXTS.get(valueType.getPackage());
        if (jaxbContext == null) {
            jaxbContext = JAXB_CONTEXTS.get(valueType);
        }
        if (jaxbContext == null) {
            try {
                jaxbContext = JAXBContext.newInstance((String)valueType.getPackage().getName());
            }
            catch (JAXBException e) {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{valueType});
                JAXB_CONTEXTS.put(valueType, jaxbContext);
            }
        }
        return jaxbContext;
    }

    public static <E> Page<E> cast(Page<?> page) {
        return page;
    }

    public static <E, T> PageResult<T> createPage(Iterable<? extends E> entries, PageRequest pageRequest, long totalSize, PageEntryTransformer<T, E> transformer) {
        PageResult page = new PageResult();
        page.setPageRequest(pageRequest == null ? new PageRequestDto() : pageRequest);
        page.setTotalSize(totalSize);
        if (entries != null) {
            for (E entry : entries) {
                if (transformer == null) {
                    page.getEntries().add(entry);
                    continue;
                }
                T targetEntry = transformer.transform(entry);
                page.getEntries().add(targetEntry);
            }
        }
        return page;
    }

    public static <E, T> Page<T> createPage(Page<? extends E> sourcePage, PageEntryTransformer<T, E> transformer) {
        if (sourcePage == null) {
            return null;
        }
        if (transformer == null) {
            return PageBuilderUtils.cast(sourcePage);
        }
        return PageBuilderUtils.createPage(sourcePage.getEntries(), sourcePage.getPageRequest(), sourcePage.getTotalSize(), transformer);
    }

    public static <E, T> PageDto createPageDto(Page<? extends E> page, PageEntryTransformer<T, E> transformer) {
        if (page == null) {
            return null;
        }
        if (page instanceof PageDto && transformer == null) {
            return (PageDto)page;
        }
        PageRequestDto pageRequestDto = PageBuilderUtils.createPageRequestDto(page.getPageRequest());
        if (transformer == null) {
            return new PageDto(page.getEntries(), pageRequestDto, page.getTotalSize());
        }
        ArrayList<T> entries = new ArrayList<T>();
        for (E e : page.getEntries()) {
            entries.add(transformer.transform(e));
        }
        PageDto pageDto = new PageDto();
        pageDto.setEntries(CastUtils.cast(entries));
        pageDto.setPageRequest(pageRequestDto);
        pageDto.setTotalSize(page.getTotalSize());
        return pageDto;
    }

    public static PageRequestDto createPageRequestDto(PageRequest pageRequest) {
        PageRequestDto pageRequestDto = pageRequest == null ? null : (pageRequest instanceof PageRequestDto ? (PageRequestDto)pageRequest : new PageRequestDto(pageRequest));
        return pageRequestDto;
    }

    public static <T, S extends T> T transform(Object xmlNodeOrJsonMap, Class<T> valueType, S defaultObject, JAXBContext jaxbContext, ObjectMapper objectMapper) throws Exception {
        if (xmlNodeOrJsonMap == null) {
            return defaultObject;
        }
        Validate.notNull(valueType, (String)"valueType must not be null", (Object[])new Object[0]);
        if (valueType.isAssignableFrom(xmlNodeOrJsonMap.getClass())) {
            return valueType.cast(xmlNodeOrJsonMap);
        }
        if (xmlNodeOrJsonMap instanceof Node) {
            return PageBuilderUtils.xmlNodeToObject((Node)xmlNodeOrJsonMap, valueType, jaxbContext);
        }
        if (xmlNodeOrJsonMap instanceof Map) {
            return PageBuilderUtils.jsonMapToObject((Map)xmlNodeOrJsonMap, valueType, objectMapper);
        }
        throw new IllegalArgumentException("xmlNodeOrJsonMap must be of type " + valueType + ", " + Node.class.getName() + " or of type " + Map.class.getName());
    }

    public static <T> T xmlNodeToObject(Node node, Class<T> valueType, JAXBContext jaxbContext) throws JAXBException {
        if (node == null) {
            return null;
        }
        Validate.notNull(valueType, (String)"valueType must not be null", (Object[])new Object[0]);
        if (jaxbContext == null) {
            return valueType.cast(PageBuilderUtils.getJaxbContext(valueType).createUnmarshaller().unmarshal(node));
        }
        return valueType.cast(jaxbContext.createUnmarshaller().unmarshal(node));
    }

    public static <T> T jsonMapToObject(Map<String, Object> map, Class<T> valueType, ObjectMapper objectMapper) throws IOException {
        if (map == null) {
            return null;
        }
        Validate.notNull(valueType, (String)"valueType must not be null", (Object[])new Object[0]);
        if (objectMapper == null) {
            return (T)DEFAULT_OBJECT_MAPPER.readValue(DEFAULT_OBJECT_MAPPER.writeValueAsBytes(map), valueType);
        }
        return (T)objectMapper.readValue(objectMapper.writeValueAsBytes(map), valueType);
    }
}

