/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.pagebuilder;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bremersee.comparator.ComparatorItemTransformer;
import org.bremersee.comparator.ComparatorItemTransformerImpl;
import org.bremersee.comparator.model.ComparatorItem;
import org.bremersee.pagebuilder.PageRequestBuilder;
import org.bremersee.pagebuilder.model.PageRequest;
import org.bremersee.pagebuilder.model.PageRequestDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageRequestBuilderImpl
implements PageRequestBuilder {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected ComparatorItemTransformer comparatorItemTransformer = new ComparatorItemTransformerImpl();
    protected boolean urlEncoded = false;
    protected String charset = StandardCharsets.UTF_8.name();

    public PageRequestBuilderImpl() {
    }

    public PageRequestBuilderImpl(ComparatorItemTransformer comparatorItemTransformer) {
        this.setComparatorItemTransformer(comparatorItemTransformer);
    }

    public PageRequestBuilderImpl(ComparatorItemTransformer comparatorItemTransformer, boolean urlEncoded, String charset) {
        this.setComparatorItemTransformer(comparatorItemTransformer);
        this.setUrlEncoded(urlEncoded);
        this.setCharset(charset);
    }

    public void setComparatorItemTransformer(ComparatorItemTransformer comparatorItemTransformer) {
        if (comparatorItemTransformer != null) {
            this.comparatorItemTransformer = comparatorItemTransformer;
        }
    }

    public void setUrlEncoded(boolean urlEncoded) {
        this.urlEncoded = urlEncoded;
    }

    public void setCharset(String charset) {
        if (StringUtils.isNotBlank((CharSequence)charset)) {
            this.charset = charset;
        }
    }

    @Override
    public PageRequest buildPageRequest(Serializable pageNumber, Serializable pageSize, Serializable comparatorItem, Serializable query, Map<String, Object> extensions) {
        return new PageRequestDto(this.getPageNumber(pageNumber), this.getPageSize(pageSize), this.getComparatorItem(comparatorItem), this.getQuery(query), extensions);
    }

    protected int getPageNumber(Serializable pageNumber) {
        int value = 0;
        if (pageNumber != null) {
            if (pageNumber instanceof Number) {
                value = ((Number)pageNumber).intValue();
            } else {
                try {
                    value = Integer.valueOf(pageNumber.toString());
                }
                catch (Throwable t) {
                    value = 0;
                    this.log.warn("Getting page number from value [" + pageNumber + "] failed. Returning " + value + ".");
                }
            }
        }
        return value >= 0 ? value : 0;
    }

    protected int getPageSize(Serializable pageSize) {
        int value = Integer.MAX_VALUE;
        if (pageSize != null) {
            if (pageSize instanceof Number) {
                value = ((Number)pageSize).intValue();
            } else {
                try {
                    value = Integer.valueOf(pageSize.toString());
                }
                catch (Throwable t) {
                    value = Integer.MAX_VALUE;
                    this.log.warn("Getting page size from value [" + pageSize + "] failed. Returning " + value + ".");
                }
            }
        }
        return value > 0 ? value : Integer.MAX_VALUE;
    }

    protected ComparatorItem getComparatorItem(Serializable comparatorItem) {
        ComparatorItem value = null;
        if (comparatorItem != null) {
            if (comparatorItem instanceof ComparatorItem) {
                value = (ComparatorItem)comparatorItem;
            } else {
                try {
                    value = this.comparatorItemTransformer.fromString(comparatorItem.toString(), this.urlEncoded, this.charset);
                }
                catch (Throwable t) {
                    value = null;
                    this.log.warn("Getting comparator item from value [" + comparatorItem + "] failed. Returning null.");
                }
            }
        }
        return value;
    }

    protected String getQuery(Serializable query) {
        return query == null ? null : query.toString();
    }
}

