/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.pagebuilder;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.annotation.PostConstruct;
import javax.xml.bind.JAXBContext;
import org.bremersee.pagebuilder.PageBuilderUtils;
import org.bremersee.pagebuilder.PageRequestExtensionExtractor;
import org.bremersee.pagebuilder.model.PageRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageRequestExtensionExtractorImpl
implements PageRequestExtensionExtractor {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected JAXBContext jaxbContext;
    protected ObjectMapper objectMapper;

    public PageRequestExtensionExtractorImpl() {
    }

    public PageRequestExtensionExtractorImpl(JAXBContext jaxbContext, ObjectMapper objectMapper) {
        this.setJaxbContext(jaxbContext);
        this.setObjectMapper(objectMapper);
    }

    protected JAXBContext getJaxbContext() {
        return null;
    }

    public void setJaxbContext(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    protected ObjectMapper getObjectMapper() {
        return null;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @PostConstruct
    public void init() {
        this.log.info("Initializing " + this.getClass().getSimpleName() + " ...");
        this.log.info("jaxbContext = " + this.getJaxbContext());
        this.log.info("objectMapper = " + this.getObjectMapper());
        this.log.info(this.getClass().getSimpleName() + " successfully initialized.");
    }

    @Override
    public <T, S extends T> T getPageRequestExtension(PageRequest pageRequest, String key, Class<T> extensionType, S defaultObject) {
        if (pageRequest == null || key == null) {
            return defaultObject;
        }
        try {
            return PageBuilderUtils.transform(pageRequest.getExtensions().get(key), extensionType, defaultObject, this.getJaxbContext(), this.getObjectMapper());
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                this.log.error("Getting page request extension from page request [" + pageRequest + "] failed.", (Throwable)e);
                throw (RuntimeException)e;
            }
            this.log.warn("Getting page request extension from page request [" + pageRequest + "] failed. Returning default value [" + defaultObject + "].", (Throwable)e);
            return defaultObject;
        }
    }
}

