/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.pagebuilder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bremersee.pagebuilder.model.Page;
import org.bremersee.pagebuilder.model.PageRequest;

public class PageResult<E>
implements Page<E> {
    private static final long serialVersionUID = 1L;
    private List<E> entries = new ArrayList();
    private PageRequest pageRequest;
    private long totalSize;

    public PageResult() {
    }

    public PageResult(Collection<? extends E> entries) {
        this(entries, null, 0L);
    }

    public PageResult(Collection<? extends E> entries, long totalSize) {
        this(entries, null, totalSize);
    }

    public PageResult(Collection<? extends E> entries, PageRequest pageRequest, long totalSize) {
        if (entries != null) {
            this.entries.addAll(entries);
        }
        this.setPageRequest(pageRequest);
        this.setTotalSize(totalSize);
    }

    public String toString() {
        return "PageResult [entries=" + this.entries + ", pageRequest=" + this.pageRequest + ", totalSize=" + this.totalSize + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entries == null ? 0 : this.entries.hashCode());
        result = 31 * result + (this.pageRequest == null ? 0 : this.pageRequest.hashCode());
        result = 31 * result + (int)(this.totalSize ^ this.totalSize >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Page)) {
            return false;
        }
        Page other = (Page)obj;
        if (this.getEntries() == null ? other.getEntries() != null : !this.getEntries().equals(other.getEntries())) {
            return false;
        }
        if (this.getPageRequest() == null ? other.getPageRequest() != null : !this.getPageRequest().equals(other.getPageRequest())) {
            return false;
        }
        return this.getTotalSize() == other.getTotalSize();
    }

    @Override
    public List<E> getEntries() {
        return this.entries;
    }

    public void setEntries(List<E> entries) {
        this.entries = entries == null ? new ArrayList() : entries;
    }

    @Override
    public PageRequest getPageRequest() {
        return this.pageRequest;
    }

    public void setPageRequest(PageRequest pageRequest) {
        this.pageRequest = pageRequest;
    }

    @Override
    public long getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    @Override
    public int getTotalPages() {
        if (this.getTotalSize() <= 0L) {
            return 1;
        }
        return (int)Math.ceil((double)this.getTotalSize() / (double)this.getPageRequest().getPageSize());
    }
}

