/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.pagebuilder.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.bremersee.pagebuilder.model.Page;
import org.bremersee.pagebuilder.model.PageRequestDto;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
@XmlRootElement(name="page")
@XmlType(name="pageType", propOrder={"entries", "pageRequest", "totalSize", "totalPages"})
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.ALWAYS)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC, creatorVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC, setterVisibility=JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC)
@JsonPropertyOrder(value={"entries", "pageRequestDto", "totalSize", "totalPages"})
@ApiModel(value="Page", description="A page is a sublist of a list of elements.")
public class PageDto
implements Page<Object> {
    private static final long serialVersionUID = 1L;
    private List<Object> entries = new ArrayList<Object>();
    private PageRequestDto pageRequest;
    private long totalSize;

    public PageDto() {
    }

    public PageDto(Collection<? extends Object> entries) {
        this(entries, null, 0L);
    }

    public PageDto(Collection<? extends Object> entries, long totalSize) {
        this(entries, null, totalSize);
    }

    public PageDto(Collection<? extends Object> entries, PageRequestDto pageRequest, long totalSize) {
        if (entries != null) {
            this.entries.addAll(entries);
        }
        this.setPageRequest(pageRequest);
        this.setTotalSize(totalSize);
    }

    public String toString() {
        return "PageDto [entries=" + this.entries + ", pageRequest=" + this.pageRequest + ", totalSize=" + this.totalSize + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entries == null ? 0 : this.entries.hashCode());
        result = 31 * result + (this.pageRequest == null ? 0 : this.pageRequest.hashCode());
        result = 31 * result + (int)(this.totalSize ^ this.totalSize >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Page)) {
            return false;
        }
        Page other = (Page)obj;
        if (this.getEntries() == null ? other.getEntries() != null : !this.getEntries().equals(other.getEntries())) {
            return false;
        }
        if (this.getPageRequest() == null ? other.getPageRequest() != null : !this.getPageRequest().equals(other.getPageRequest())) {
            return false;
        }
        return this.getTotalSize() == other.getTotalSize();
    }

    @Override
    @XmlElementWrapper(name="entries")
    @XmlElement(name="entry", nillable=true, type=Object.class)
    @JsonProperty(value="entries", required=false)
    @ApiModelProperty(value="The elements of the page.", position=0, required=false)
    public List<Object> getEntries() {
        return this.entries;
    }

    @JsonProperty(value="entries", required=false)
    public void setEntries(List<Object> entries) {
        if (entries == null) {
            entries = new ArrayList<Object>();
        }
        this.entries = entries;
    }

    @Override
    @XmlElement(name="pageRequest", required=true)
    @JsonProperty(value="pageRequest", required=true)
    @ApiModelProperty(value="The page request.", position=1, required=true)
    public PageRequestDto getPageRequest() {
        if (this.pageRequest == null) {
            this.pageRequest = new PageRequestDto();
        }
        return this.pageRequest;
    }

    @JsonProperty(value="pageRequest", required=false)
    public void setPageRequest(PageRequestDto pageRequest) {
        this.pageRequest = pageRequest;
    }

    @Override
    @XmlElement(name="totalSize", required=true)
    @JsonProperty(value="totalSize", required=true)
    @ApiModelProperty(value="The total size of available elements.", position=2, required=true)
    public long getTotalSize() {
        return this.totalSize;
    }

    @JsonProperty(value="totalSize", required=false)
    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    @Override
    @XmlElement(name="totalPages", required=true)
    @JsonProperty(value="totalPages", required=true)
    @ApiModelProperty(value="The total size of available pages.", position=3, required=true, readOnly=true)
    public int getTotalPages() {
        if (this.getTotalSize() <= 0L) {
            return 1;
        }
        return (int)Math.ceil((double)this.getTotalSize() / (double)this.getPageRequest().getPageSize());
    }

    @JsonProperty(value="totalPages", required=false)
    public void setTotalPages(int totalPages) {
    }
}

