/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.pagebuilder.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.Validate;
import org.bremersee.comparator.model.ComparatorItem;
import org.bremersee.pagebuilder.model.PageRequest;
import org.bremersee.pagebuilder.model.PageRequestLinkDto;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
@XmlRootElement(name="pageRequest")
@XmlType(name="pageRequestType", propOrder={"pageNumber", "pageSize", "firstResult", "comparatorItem", "query", "extensions"})
@XmlSeeAlso(value={PageRequestLinkDto.class})
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.ALWAYS)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC, creatorVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC, setterVisibility=JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC)
@JsonPropertyOrder(value={"pageNumber", "pageSize", "firstResult", "comparatorItem", "query", "extensions"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=PageRequestDto.class, name="PageRequestDto"), @JsonSubTypes.Type(value=PageRequestLinkDto.class, name="PageRequestLinkDto")})
@ApiModel(value="PageRequest", description="A page request defines which page is requested (by it's page number), how many elements the page may have, and how the elements are sorted. Furthermore a query value can be specified and custom extensions, which may be handled by the business logic.", discriminator="type", subTypes={PageRequestLinkDto.class})
public class PageRequestDto
implements PageRequest,
Comparable<PageRequest> {
    private static final long serialVersionUID = 1L;
    private int pageNumber = 0;
    private int pageSize = Integer.MAX_VALUE;
    private ComparatorItem comparatorItem;
    private String query;
    private Map<String, Object> extensions = new LinkedHashMap<String, Object>();

    public PageRequestDto() {
    }

    public PageRequestDto(PageRequest pageRequest) {
        if (pageRequest != null) {
            this.setComparatorItem(pageRequest.getComparatorItem());
            this.setExtensions(pageRequest.getExtensions());
            this.setPageNumber(pageRequest.getPageNumber());
            this.setPageSize(pageRequest.getPageSize());
            this.setExtensions(pageRequest.getExtensions());
        }
    }

    public PageRequestDto(int pageNumber, int pageSize) {
        this(pageNumber, pageSize, null, null, null);
    }

    public PageRequestDto(int pageNumber, int pageSize, ComparatorItem comparatorItem) {
        this(pageNumber, pageSize, comparatorItem, null, null);
    }

    public PageRequestDto(int pageNumber, int pageSize, ComparatorItem comparatorItem, String query) {
        this(pageNumber, pageSize, comparatorItem, query, null);
    }

    public PageRequestDto(int pageNumber, int pageSize, ComparatorItem comparatorItem, String query, Map<String, Object> extensions) {
        this.setPageNumber(pageNumber);
        this.setPageSize(pageSize);
        this.setComparatorItem(comparatorItem);
        this.setQuery(query);
        this.setExtensions(extensions);
    }

    public String toString() {
        return "PageRequestDto [pageNumber=" + this.pageNumber + ", pageSize=" + this.pageSize + ", comparatorItem=" + this.comparatorItem + ", query=" + this.query + ", extensions=" + this.extensions + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.comparatorItem == null ? 0 : this.comparatorItem.hashCode());
        result = 31 * result + (this.extensions == null ? 0 : this.extensions.hashCode());
        result = 31 * result + this.pageNumber;
        result = 31 * result + this.pageSize;
        result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PageRequest)) {
            return false;
        }
        PageRequest other = (PageRequest)obj;
        if (this.getComparatorItem() == null ? other.getComparatorItem() != null : !this.getComparatorItem().equals((Object)other.getComparatorItem())) {
            return false;
        }
        if (this.getExtensions() == null ? other.getExtensions() != null : !this.getExtensions().equals(other.getExtensions())) {
            return false;
        }
        if (this.getPageNumber() != other.getPageNumber()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        return !(this.getQuery() == null ? other.getQuery() != null : !this.getQuery().equals(other.getQuery()));
    }

    @Override
    public int compareTo(PageRequest pageRequest) {
        if (pageRequest == null) {
            return -1;
        }
        return this.getPageNumber() - pageRequest.getPageNumber();
    }

    @Override
    @XmlElement(name="pageNumber", required=true)
    @JsonProperty(value="pageNumber", required=true)
    @ApiModelProperty(value="The page number.", required=true)
    public int getPageNumber() {
        return this.pageNumber;
    }

    @JsonProperty(value="pageNumber", required=true)
    public void setPageNumber(int pageNumber) {
        Validate.isTrue((pageNumber >= 0 ? 1 : 0) != 0, (String)"Page number must be 0 or greater than 0.", (Object[])new Object[0]);
        this.pageNumber = pageNumber;
    }

    @Override
    @XmlElement(name="pageSize", required=true)
    @JsonProperty(value="pageSize", required=true)
    @ApiModelProperty(value="The maximum number of elements on the page.", position=1, required=true)
    public int getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="pageSize", required=true)
    public void setPageSize(int pageSize) {
        Validate.isTrue((pageSize >= 1 ? 1 : 0) != 0, (String)"Page number must be 1 or greater than 1.", (Object[])new Object[0]);
        this.pageSize = pageSize;
    }

    @Override
    @XmlElement(name="firstResult")
    @JsonProperty(value="firstResult")
    @ApiModelProperty(value="The first result (offset).", position=2, readOnly=true)
    public int getFirstResult() {
        long firstResult = (long)this.getPageNumber() * (long)this.getPageSize();
        if (firstResult < Integer.MAX_VALUE) {
            return (int)firstResult;
        }
        return Integer.MAX_VALUE;
    }

    @JsonProperty(value="firstResult")
    protected void setFirstResult(Integer firstResult) {
    }

    @Override
    @XmlElement(name="comparatorItem")
    @JsonProperty(value="comparatorItem")
    @ApiModelProperty(value="The comparator item.", position=3)
    public ComparatorItem getComparatorItem() {
        return this.comparatorItem;
    }

    @JsonProperty(value="comparatorItem")
    public void setComparatorItem(ComparatorItem comparatorItem) {
        this.comparatorItem = comparatorItem;
    }

    @Override
    @XmlElement(name="query")
    @JsonProperty(value="query")
    @ApiModelProperty(value="A query value.", position=4)
    public String getQuery() {
        return this.query;
    }

    @JsonProperty(value="query")
    public void setQuery(String query) {
        this.query = query;
    }

    @Override
    @JsonProperty(value="extensions")
    @ApiModelProperty(value="Custom extensions.", position=4)
    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    @JsonProperty(value="extensions")
    public void setExtensions(Map<String, Object> extensions) {
        if (extensions == null) {
            this.extensions.clear();
        } else if (extensions instanceof LinkedHashMap) {
            this.extensions = extensions;
        } else {
            this.extensions.clear();
            this.extensions.putAll(extensions);
        }
    }
}

