/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.pagebuilder.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.bremersee.comparator.model.ComparatorItem;
import org.bremersee.pagebuilder.model.PageRequestDto;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
@XmlRootElement(name="pageRequestLink")
@XmlType(name="pageRequestLinkType", propOrder={"displayedPageNumber", "active", "url"})
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.ALWAYS)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC, creatorVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC, setterVisibility=JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC)
@JsonPropertyOrder(value={"displayedPageNumber", "active", "url"})
@ApiModel(value="PageRequestLink", description="A page request link contains beside the page request information a link (to another page) and a flag whether this page request is the current one.", parent=PageRequestDto.class)
public class PageRequestLinkDto
extends PageRequestDto {
    private static final long serialVersionUID = 1L;
    private boolean active;
    private String url;

    public PageRequestLinkDto() {
    }

    public PageRequestLinkDto(PageRequestDto pageRequest, boolean active, String url) {
        if (pageRequest != null) {
            this.setComparatorItem(pageRequest.getComparatorItem());
            this.setExtensions(pageRequest.getExtensions());
            this.setPageNumber(pageRequest.getPageNumber());
            this.setPageSize(pageRequest.getPageSize());
            this.setQuery(pageRequest.getQuery());
        }
        this.setActive(active);
        this.setUrl(url);
    }

    public PageRequestLinkDto(int pageNumber, int pageSize, ComparatorItem comparatorItem, String query, Map<String, Object> extensions, boolean active, String url) {
        super(pageNumber, pageSize, comparatorItem, query, extensions);
        this.active = active;
        this.url = url;
    }

    @Override
    public String toString() {
        return "PageRequestLinkDto [active=" + this.active + ", url=" + this.url + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.active ? 1231 : 1237);
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageRequestLinkDto other = (PageRequestLinkDto)obj;
        if (this.active != other.active) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    @XmlElement(name="displayedPageNumber", required=true)
    @JsonProperty(value="displayedPageNumber", required=true)
    @ApiModelProperty(value="The page number for displaying (page number + 1).", required=true, readOnly=true)
    public String getDisplayedPageNumber() {
        return Integer.valueOf(this.getPageNumber() + 1).toString();
    }

    @JsonProperty(value="displayedPageNumber")
    protected void setDisplayedPageNumber(String displayedPageNumber) {
    }

    @XmlElement(name="active", required=true)
    @JsonProperty(value="active", required=true)
    @ApiModelProperty(value="Is this page the current one?", position=1, required=true)
    public boolean isActive() {
        return this.active;
    }

    @JsonProperty(value="active", required=true)
    public void setActive(boolean active) {
        this.active = active;
    }

    @XmlElement(name="url")
    @JsonProperty(value="url")
    @ApiModelProperty(value="An URL to another page.", position=2)
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.url = url;
    }
}

