/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.pagebuilder.spring;

import java.util.ArrayList;
import org.bremersee.comparator.model.ComparatorItem;
import org.bremersee.comparator.spring.ComparatorSpringUtils;
import org.bremersee.pagebuilder.PageBuilderUtils;
import org.bremersee.pagebuilder.PageEntryTransformer;
import org.bremersee.pagebuilder.PageResult;
import org.bremersee.pagebuilder.model.PageRequest;
import org.bremersee.pagebuilder.model.PageRequestDto;
import org.bremersee.pagebuilder.spring.SpringPageImpl;
import org.bremersee.pagebuilder.spring.SpringPageRequest;
import org.bremersee.pagebuilder.spring.SpringPageRequestImpl;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public abstract class PageBuilderSpringUtils {
    private PageBuilderSpringUtils() {
    }

    public static SpringPageRequest toSpringPageRequest(PageRequest pageRequest) {
        int pageSize;
        if (pageRequest == null) {
            return null;
        }
        int pageNumber = pageRequest.getPageNumber();
        long firstResult = (long)pageNumber * (long)(pageSize = pageRequest.getPageSize());
        if (firstResult > Integer.MAX_VALUE) {
            pageNumber = 0;
        }
        return new SpringPageRequestImpl(pageNumber, pageSize, ComparatorSpringUtils.toSort((ComparatorItem)pageRequest.getComparatorItem()), pageRequest.getQuery(), pageRequest.getExtensions());
    }

    public static PageRequestDto fromSpringPageRequest(Pageable pageable) {
        if (pageable == null) {
            return null;
        }
        PageRequestDto pageRequest = new PageRequestDto();
        pageRequest.setComparatorItem(ComparatorSpringUtils.fromSort((Sort)pageable.getSort()));
        pageRequest.setPageNumber(pageable.getPageNumber());
        pageRequest.setPageSize(pageable.getPageSize());
        if (pageable instanceof SpringPageRequestImpl) {
            SpringPageRequestImpl spr = (SpringPageRequestImpl)pageable;
            pageRequest.setExtensions(spr.getExtensions());
            pageRequest.setQuery(spr.getQuery());
        }
        return pageRequest;
    }

    public static <E> PageImpl<E> toSpringPage(org.bremersee.pagebuilder.model.Page<E> page) {
        if (page == null) {
            return null;
        }
        return new SpringPageImpl<E>(page.getEntries(), PageBuilderSpringUtils.toSpringPageRequest(page.getPageRequest()), page.getTotalSize());
    }

    public static <E, T> PageImpl<T> toSpringPage(org.bremersee.pagebuilder.model.Page<E> page, PageEntryTransformer<T, E> transformer) {
        if (page == null) {
            return null;
        }
        if (transformer == null) {
            transformer = new PageEntryTransformer<T, E>(){

                @Override
                public T transform(E source) {
                    return source;
                }
            };
        }
        ArrayList transformedEntries = new ArrayList(page.getEntries().size());
        for (E entry : page.getEntries()) {
            transformedEntries.add(transformer.transform(entry));
        }
        return new SpringPageImpl(transformedEntries, PageBuilderSpringUtils.toSpringPageRequest(page.getPageRequest()), page.getTotalSize());
    }

    public static <E> PageResult<E> fromSpringPage(Page<E> springPage) {
        if (springPage == null) {
            return null;
        }
        PageRequestDto pageRequest = PageBuilderSpringUtils.getPageRequest(springPage);
        return new PageResult(springPage.getContent(), pageRequest, springPage.getTotalElements());
    }

    public static <E, T> PageResult<T> fromSpringPage(Page<E> springPage, PageEntryTransformer<T, E> transformer) {
        if (springPage == null) {
            return null;
        }
        if (transformer == null) {
            transformer = new PageEntryTransformer<T, E>(){

                @Override
                public T transform(E source) {
                    return source;
                }
            };
        }
        PageRequestDto pageRequest = PageBuilderSpringUtils.getPageRequest(springPage);
        return PageBuilderUtils.createPage(springPage.getContent(), pageRequest, springPage.getTotalElements(), transformer);
    }

    private static PageRequestDto getPageRequest(Page<?> springPage) {
        if (springPage == null) {
            return null;
        }
        if (springPage instanceof SpringPageImpl && ((SpringPageImpl)springPage).getPageable() != null) {
            return PageBuilderSpringUtils.fromSpringPageRequest(((SpringPageImpl)springPage).getPageable());
        }
        PageRequestDto pageRequest = new PageRequestDto();
        pageRequest.setComparatorItem(ComparatorSpringUtils.fromSort((Sort)springPage.getSort()));
        pageRequest.setPageNumber(springPage.getNumber());
        pageRequest.setPageSize(springPage.getSize());
        return pageRequest;
    }
}

