/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.Provider;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.bremersee.utils.CodingException;
import org.bremersee.utils.InputStreamListener;

public abstract class CodingUtils {
    private CodingUtils() {
    }

    public static MessageDigest getMessageDigestSilently(String algorithm) {
        Validate.notBlank((CharSequence)algorithm, (String)"Algotithm must not be null or blank.", (Object[])new Object[0]);
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (Exception e) {
            throw new CodingException(e);
        }
    }

    public static MessageDigest getMessageDigestSilently(String algorithm, String provider) {
        Validate.notBlank((CharSequence)algorithm, (String)"Algotithm must not be null or blank.", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)provider)) {
            return CodingUtils.getMessageDigestSilently(algorithm);
        }
        try {
            return MessageDigest.getInstance(algorithm, provider);
        }
        catch (Exception e) {
            throw new CodingException(e);
        }
    }

    public static MessageDigest getMessageDigestSilently(String algorithm, Provider provider) {
        Validate.notBlank((CharSequence)algorithm, (String)"Algotithm must not be null or blank.", (Object[])new Object[0]);
        if (provider == null) {
            return CodingUtils.getMessageDigestSilently(algorithm);
        }
        try {
            return MessageDigest.getInstance(algorithm, provider);
        }
        catch (Exception e) {
            throw new CodingException(e);
        }
    }

    public static byte[] digestSilently(MessageDigest md, byte[] bytes) {
        return CodingUtils.digestSilently(md, bytes, null);
    }

    public static byte[] digestSilently(MessageDigest md, byte[] bytes, InputStreamListener listener) {
        Validate.notNull((Object)bytes, (String)"Bytes must not be null.", (Object[])new Object[0]);
        return CodingUtils.digestSilently(md, new ByteArrayInputStream(bytes), true, listener);
    }

    public static byte[] digestSilently(MessageDigest md, InputStream inputStream, boolean closeInputStream) {
        return CodingUtils.digestSilently(md, inputStream, closeInputStream, null);
    }

    public static byte[] digestSilently(MessageDigest md, InputStream inputStream, boolean closeInputStream, InputStreamListener listener) {
        Validate.notNull((Object)md, (String)"MessageDigest must not be null.", (Object[])new Object[0]);
        Validate.notNull((Object)inputStream, (String)"InputStream must not be null.", (Object[])new Object[0]);
        try {
            int len;
            md.reset();
            byte[] buffer = new byte[4096];
            while ((len = inputStream.read(buffer)) != -1) {
                md.update(buffer, 0, len);
                if (listener == null) continue;
                listener.onReadBytes(buffer, 0, len);
            }
            byte[] byArray = md.digest();
            return byArray;
        }
        catch (Exception e) {
            throw new CodingException(e);
        }
        finally {
            if (closeInputStream) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static String toHex(byte[] bytes) {
        return CodingUtils.toHex(bytes, false);
    }

    public static String toHex(byte[] bytes, boolean upperCase) {
        if (bytes == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (byte aByte : bytes) {
            sb.append(Integer.toString((aByte & 0xFF) + 256, 16).substring(1));
        }
        return upperCase ? sb.toString().toUpperCase() : sb.toString().toLowerCase();
    }

    public static byte[] toBytesSilently(String text, String charsetName) {
        if (text == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)charsetName)) {
            return text.getBytes();
        }
        try {
            return text.getBytes(charsetName);
        }
        catch (Exception e) {
            throw new CodingException(e);
        }
    }

    public static byte[] toBytesSilently(String text, Charset charset) {
        if (text == null) {
            return null;
        }
        if (charset == null) {
            return text.getBytes();
        }
        return text.getBytes(charset);
    }

    public static String toStringSilently(byte[] bytes, String charsetName) {
        if (bytes == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)charsetName)) {
            return new String(bytes);
        }
        try {
            return new String(bytes, charsetName);
        }
        catch (Exception e) {
            throw new CodingException(e);
        }
    }

    public static String toStringSilently(byte[] bytes, Charset charset) {
        if (bytes == null) {
            return null;
        }
        if (charset == null) {
            return new String(bytes);
        }
        return new String(bytes, charset);
    }
}

