/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.bremersee.utils.IORuntimeException;
import org.bremersee.utils.InputStreamListener;
import org.bremersee.utils.ReaderListener;

public abstract class IoUtils {
    private IoUtils() {
    }

    public static long copySilently(InputStream inputStream, OutputStream outputStream, boolean closeStreams) {
        return IoUtils.copySilently(inputStream, outputStream, closeStreams, null);
    }

    public static long copySilently(InputStream inputStream, OutputStream outputStream, boolean closeStreams, InputStreamListener listener) {
        long totalLen = 0L;
        byte[] buf = new byte[4096];
        try {
            int len;
            while ((len = inputStream.read(buf)) != -1) {
                outputStream.write(buf, 0, len);
                totalLen += (long)len;
                if (listener == null) continue;
                listener.onReadBytes(buf, 0, len);
            }
            outputStream.flush();
        }
        catch (Exception e) {
            throw new IORuntimeException(e);
        }
        finally {
            if (closeStreams) {
                IoUtils.closeSilently(inputStream);
                IoUtils.closeSilently(outputStream);
            }
        }
        return totalLen;
    }

    public static long copySilently(Reader reader, Writer writer, boolean closeReaderAndWriter) {
        return IoUtils.copySilently(reader, writer, closeReaderAndWriter, null);
    }

    public static long copySilently(Reader reader, Writer writer, boolean closeReaderAndWriter, ReaderListener listener) {
        long totalLen = 0L;
        char[] buf = new char[4096];
        try {
            int len;
            while ((len = reader.read(buf)) != -1) {
                writer.write(buf, 0, len);
                totalLen += (long)len;
                if (listener == null) continue;
                listener.onReadChars(buf, 0, len);
            }
            writer.flush();
        }
        catch (Exception e) {
            throw new IORuntimeException(e);
        }
        finally {
            if (closeReaderAndWriter) {
                IoUtils.closeSilently(reader);
                IoUtils.closeSilently(writer);
            }
        }
        return totalLen;
    }

    public static void closeSilently(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

