/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class LocaleUtils {
    private static final Set<String> LANG_CODES = new HashSet<String>();
    private static final Map<String, String> ISO3_LANG_CODES = new HashMap<String, String>();
    private static final Set<String> COUNTRY_CODES = new HashSet<String>();
    private static final Map<String, String> ISO3_COUNTRY_CODES = new HashMap<String, String>();

    private LocaleUtils() {
    }

    public static String validateLanguageCode(String languageCode) {
        return LocaleUtils.validateLanguageCode(languageCode, null);
    }

    public static String validateLanguageCode(String languageCode, String defaultLanguageCode) {
        String lang = LocaleUtils.extractLanguageCode(languageCode);
        if (lang != null && (lang.length() == 2 || lang.length() == 3)) {
            if (LANG_CODES.contains(lang)) {
                return lang;
            }
            String langFromIso3 = ISO3_LANG_CODES.get(lang);
            if (langFromIso3 != null) {
                return langFromIso3;
            }
        }
        if (defaultLanguageCode == null) {
            return StringUtils.isBlank((CharSequence)Locale.getDefault().getLanguage()) ? "de" : Locale.getDefault().getLanguage();
        }
        return LocaleUtils.validateLanguageCode(defaultLanguageCode, null);
    }

    private static String extractLanguageCode(String languageCode) {
        if (languageCode == null || languageCode.length() < 2) {
            return null;
        }
        int index = languageCode.indexOf(95);
        String value = index >= 2 ? languageCode.substring(0, index) : languageCode;
        if (value.length() >= 3) {
            return value.substring(0, 3).toLowerCase();
        }
        return value.toLowerCase();
    }

    public static String validateCountryCode(String countryCode) {
        return LocaleUtils.validateCountryCode(countryCode, null);
    }

    public static String validateCountryCode(String countryCode, String defaultCountryCode) {
        String cc = LocaleUtils.extractCountryCode(countryCode);
        if (cc != null && (cc.length() == 2 || cc.length() == 3)) {
            if (COUNTRY_CODES.contains(cc)) {
                return cc;
            }
            String country = ISO3_COUNTRY_CODES.get(cc);
            if (country != null) {
                return country;
            }
        }
        if (StringUtils.isBlank((CharSequence)defaultCountryCode)) {
            return StringUtils.isBlank((CharSequence)Locale.getDefault().getCountry()) ? "DE" : Locale.getDefault().getCountry();
        }
        return LocaleUtils.validateCountryCode(defaultCountryCode, null);
    }

    private static String extractCountryCode(String countryCode) {
        if (countryCode == null) {
            return null;
        }
        String[] values = countryCode.split("_");
        if (values.length >= 2) {
            return LocaleUtils.extractCountryCode(values[1]);
        }
        String value = values[0];
        if (value.length() < 2) {
            return null;
        }
        if (value.length() >= 3) {
            return value.substring(0, 3).toUpperCase();
        }
        return value.toUpperCase();
    }

    public static Locale fromString(String localeAsString, boolean countryRequired) {
        String countryCode;
        if (localeAsString == null) {
            return Locale.getDefault();
        }
        String languageCode = LocaleUtils.validateLanguageCode(localeAsString);
        String[] values = localeAsString.split("_");
        String string = countryCode = values.length >= 2 ? values[1] : null;
        if (countryRequired) {
            countryCode = LocaleUtils.validateCountryCode(countryCode);
        } else if (countryCode != null && !COUNTRY_CODES.contains(countryCode.toUpperCase())) {
            countryCode = ISO3_COUNTRY_CODES.get(countryCode.toUpperCase());
        }
        if (countryCode == null) {
            return new Locale(languageCode);
        }
        if (values.length >= 3 && values[2].length() > 0) {
            return new Locale(languageCode, countryCode, values[2]);
        }
        return new Locale(languageCode, countryCode);
    }

    static {
        for (Locale locale : Locale.getAvailableLocales()) {
            String country;
            String lang = locale.getLanguage();
            if (lang != null) {
                LANG_CODES.add(lang.toLowerCase());
                try {
                    String iso3 = locale.getISO3Language();
                    if (iso3 != null) {
                        ISO3_LANG_CODES.put(iso3.toLowerCase(), lang.toLowerCase());
                    }
                }
                catch (RuntimeException iso3) {
                    // empty catch block
                }
            }
            if ((country = locale.getCountry()) == null) continue;
            COUNTRY_CODES.add(country.toUpperCase());
            try {
                String iso3 = locale.getISO3Country();
                if (iso3 == null) continue;
                ISO3_COUNTRY_CODES.put(iso3.toUpperCase(), country.toUpperCase());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }
}

