/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;

public abstract class MailUtils {
    public static final String EMAIL_REGEX = "^\\S+@\\S+$";
    public static final String BREMERSEE_EMAIL_REGEX = "[a-zA-Z0-9!#$&'*+/=?^_`{|}~-]+(?:\\.[a-zA-Z0-9!#$&'*+/=?^_`{|}~-]+)*@(?:[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?\\.)+[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?";
    private static final Set<Character> LEGAL_CHARS_IN_MAIL_LOCAL_PART;
    private static final Map<Character, String> REPLACE_CHARS_IN_MAIL_LOCAL_PART_MAP;

    private MailUtils() {
    }

    public static String buildMailAddress(String localPart, String mailDomain) {
        Validate.notBlank((CharSequence)localPart, (String)"localPart must not be null or blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)mailDomain, (String)"mailDomain must not be null or blank", (Object[])new Object[0]);
        StringBuilder localPartBuilder = new StringBuilder();
        for (int i = 0; i < localPart.length(); ++i) {
            Character c = Character.valueOf(localPart.charAt(i));
            if (LEGAL_CHARS_IN_MAIL_LOCAL_PART.contains(c)) {
                localPartBuilder.append(c);
                continue;
            }
            String r = REPLACE_CHARS_IN_MAIL_LOCAL_PART_MAP.get(c);
            if (r == null) {
                localPartBuilder.append('_');
                continue;
            }
            localPartBuilder.append(r);
        }
        return localPartBuilder.toString() + "@" + mailDomain;
    }

    static {
        int i;
        HashSet<Character> tmpCharSet = new HashSet<Character>();
        int n0 = 48;
        int n9 = 57;
        int A = 65;
        int Z = 90;
        int a = 97;
        int z = 122;
        char[] x = new char[]{'#', '$', '&', '\'', '*', '+', '-', '/', '=', '?', '^', '_', '`', '{', '|', '}', '~', '.'};
        StringBuilder sb = new StringBuilder();
        for (i = n0; i <= n9; ++i) {
            sb.append((char)i);
        }
        for (i = A; i <= Z; ++i) {
            sb.append((char)i);
        }
        for (i = a; i <= z; ++i) {
            sb.append((char)i);
        }
        sb.append(x);
        for (i = 0; i < sb.length(); ++i) {
            tmpCharSet.add(Character.valueOf(sb.charAt(i)));
        }
        LEGAL_CHARS_IN_MAIL_LOCAL_PART = Collections.unmodifiableSet(tmpCharSet);
        HashMap<Character, String> tmpReplaceCharsMap = new HashMap<Character, String>();
        tmpReplaceCharsMap.put(Character.valueOf('('), "{");
        tmpReplaceCharsMap.put(Character.valueOf(')'), "}");
        tmpReplaceCharsMap.put(Character.valueOf('['), "{");
        tmpReplaceCharsMap.put(Character.valueOf(']'), "}");
        tmpReplaceCharsMap.put(Character.valueOf('\\'), "/");
        tmpReplaceCharsMap.put(Character.valueOf('\u00c4'), "Ae");
        tmpReplaceCharsMap.put(Character.valueOf('\u00d6'), "Oe");
        tmpReplaceCharsMap.put(Character.valueOf('\u00dc'), "Ue");
        tmpReplaceCharsMap.put(Character.valueOf('\u00e4'), "ae");
        tmpReplaceCharsMap.put(Character.valueOf('\u00f6'), "oe");
        tmpReplaceCharsMap.put(Character.valueOf('\u00fc'), "ue");
        tmpReplaceCharsMap.put(Character.valueOf('\u00df'), "ss");
        tmpReplaceCharsMap.put(Character.valueOf('\u00c1'), "A");
        tmpReplaceCharsMap.put(Character.valueOf('\u00c9'), "E");
        tmpReplaceCharsMap.put(Character.valueOf('\u00cd'), "I");
        tmpReplaceCharsMap.put(Character.valueOf('\u00d3'), "O");
        tmpReplaceCharsMap.put(Character.valueOf('\u00da'), "U");
        tmpReplaceCharsMap.put(Character.valueOf('\u00e1'), "a");
        tmpReplaceCharsMap.put(Character.valueOf('\u00e9'), "e");
        tmpReplaceCharsMap.put(Character.valueOf('\u00ed'), "i");
        tmpReplaceCharsMap.put(Character.valueOf('\u00f3'), "o");
        tmpReplaceCharsMap.put(Character.valueOf('\u00fa'), "u");
        tmpReplaceCharsMap.put(Character.valueOf('\u00c0'), "A");
        tmpReplaceCharsMap.put(Character.valueOf('\u00c8'), "E");
        tmpReplaceCharsMap.put(Character.valueOf('\u00cc'), "I");
        tmpReplaceCharsMap.put(Character.valueOf('\u00d2'), "O");
        tmpReplaceCharsMap.put(Character.valueOf('\u00d9'), "U");
        tmpReplaceCharsMap.put(Character.valueOf('\u00e0'), "a");
        tmpReplaceCharsMap.put(Character.valueOf('\u00e8'), "e");
        tmpReplaceCharsMap.put(Character.valueOf('\u00ec'), "i");
        tmpReplaceCharsMap.put(Character.valueOf('\u00f2'), "o");
        tmpReplaceCharsMap.put(Character.valueOf('\u00f9'), "u");
        tmpReplaceCharsMap.put(Character.valueOf('\u00c2'), "A");
        tmpReplaceCharsMap.put(Character.valueOf('\u00ca'), "E");
        tmpReplaceCharsMap.put(Character.valueOf('\u00ce'), "I");
        tmpReplaceCharsMap.put(Character.valueOf('\u00d4'), "O");
        tmpReplaceCharsMap.put(Character.valueOf('\u00db'), "U");
        tmpReplaceCharsMap.put(Character.valueOf('\u00e2'), "a");
        tmpReplaceCharsMap.put(Character.valueOf('\u00ea'), "e");
        tmpReplaceCharsMap.put(Character.valueOf('\u00ee'), "i");
        tmpReplaceCharsMap.put(Character.valueOf('\u00f4'), "o");
        tmpReplaceCharsMap.put(Character.valueOf('\u00fb'), "u");
        REPLACE_CHARS_IN_MAIL_LOCAL_PART_MAP = Collections.unmodifiableMap(tmpReplaceCharsMap);
    }
}

