/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;

public abstract class MapUtils {
    private MapUtils() {
    }

    public static <K, V> Map<K, V> sort(Map<? extends K, ? extends V> map) {
        return MapUtils.sort(map, null);
    }

    public static <K, V> Map<K, V> sort(Map<? extends K, ? extends V> map, Comparator<? extends V> valueComparator) {
        Validate.notNull(map, (String)"Map must not be null.", (Object[])new Object[0]);
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(entries, new MapEntryComparator(valueComparator));
        LinkedHashMap sortedMap = new LinkedHashMap(entries.size());
        for (Map.Entry entry : entries) {
            sortedMap.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(sortedMap);
    }

    public static Object getFirstValue(Map<?, ?> map, Object key, Object defaultValue) {
        List<?> list = MapUtils.getValueAsList(map, key);
        if (list.isEmpty()) {
            return defaultValue;
        }
        return list.get(0);
    }

    public static Collection<?> getValueAsCollection(Map<?, ?> map, Object key) {
        Validate.notNull(map, (String)"Map must not be null.", (Object[])new Object[0]);
        Validate.notNull(map, (String)"Key must not be null.", (Object[])new Object[0]);
        Object value = map.get(key);
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value.getClass().isArray()) {
            if (value instanceof boolean[]) {
                boolean[] values = (boolean[])value;
                ArrayList<Boolean> list = new ArrayList<Boolean>(values.length);
                for (boolean v : values) {
                    list.add(v);
                }
                return list;
            }
            if (value instanceof byte[]) {
                byte[] values = (byte[])value;
                ArrayList<Byte> list = new ArrayList<Byte>(values.length);
                for (byte v : values) {
                    list.add(v);
                }
                return list;
            }
            if (value instanceof short[]) {
                short[] values = (short[])value;
                ArrayList<Short> list = new ArrayList<Short>(values.length);
                for (short v : values) {
                    list.add(v);
                }
                return list;
            }
            if (value instanceof int[]) {
                int[] values = (int[])value;
                ArrayList<Integer> list = new ArrayList<Integer>(values.length);
                for (int v : values) {
                    list.add(v);
                }
                return list;
            }
            if (value instanceof long[]) {
                long[] values = (long[])value;
                ArrayList<Long> list = new ArrayList<Long>(values.length);
                for (long v : values) {
                    list.add(v);
                }
                return list;
            }
            if (value instanceof char[]) {
                char[] values = (char[])value;
                ArrayList<Character> list = new ArrayList<Character>(values.length);
                for (char v : values) {
                    list.add(Character.valueOf(v));
                }
                return list;
            }
            if (value instanceof float[]) {
                float[] values = (float[])value;
                ArrayList<Float> list = new ArrayList<Float>(values.length);
                for (float v : values) {
                    list.add(Float.valueOf(v));
                }
                return list;
            }
            if (value instanceof double[]) {
                double[] values = (double[])value;
                ArrayList<Double> list = new ArrayList<Double>(values.length);
                for (double v : values) {
                    list.add(v);
                }
                return list;
            }
            Object[] values = (Object[])value;
            ArrayList<Object> list = new ArrayList<Object>(values.length);
            for (Object v : values) {
                list.add(v);
            }
            return list;
        }
        ArrayList list = new ArrayList(1);
        list.add(value);
        return list;
    }

    public static List<?> getValueAsList(Map<?, ?> map, Object key) {
        Collection<?> col = MapUtils.getValueAsCollection(map, key);
        if (col instanceof List) {
            return (List)col;
        }
        return new ArrayList(col);
    }

    public static Set<?> getValueAsSet(Map<?, ?> map, Object key) {
        Collection<?> col = MapUtils.getValueAsCollection(map, key);
        if (col instanceof Set) {
            return (Set)col;
        }
        return new LinkedHashSet(col);
    }

    public static String getValueAsString(Map<?, ?> map, Object key, String defaultValue) {
        Object value = MapUtils.getFirstValue(map, key, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }

    public static Boolean getValueAsBoolean(Map<?, ?> map, Object key, Boolean defaultValue) {
        Object value = MapUtils.getFirstValue(map, key, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        try {
            return Boolean.valueOf(value.toString().toLowerCase());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static BigInteger getValueAsBigInteger(Map<?, ?> map, Object key, BigInteger defaultValue) {
        Object value = MapUtils.getFirstValue(map, key, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        try {
            return new BigInteger(value.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Long getValueAsLong(Map<?, ?> map, Object key, Long defaultValue) {
        Object value = MapUtils.getFirstValue(map, key, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        try {
            return Long.valueOf(value.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Integer getValueAsInteger(Map<?, ?> map, Object key, Integer defaultValue) {
        Object value = MapUtils.getFirstValue(map, key, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        try {
            return Integer.valueOf(value.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Byte getValueAsByte(Map<?, ?> map, Object key, Byte defaultValue) {
        Object value = MapUtils.getFirstValue(map, key, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        try {
            return Byte.valueOf(value.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Short getValueAsShort(Map<?, ?> map, Object key, Short defaultValue) {
        Object value = MapUtils.getFirstValue(map, key, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        try {
            return Short.valueOf(value.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static BigDecimal getValueAsBigDecimal(Map<?, ?> map, Object key, BigDecimal defaultValue) {
        Object value = MapUtils.getFirstValue(map, key, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        try {
            return new BigDecimal(value.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Double getValueAsDouble(Map<?, ?> map, Object key, Double defaultValue) {
        Object value = MapUtils.getFirstValue(map, key, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        try {
            return Double.valueOf(value.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Float getValueAsFloat(Map<?, ?> map, Object key, Float defaultValue) {
        Object value = MapUtils.getFirstValue(map, key, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        try {
            return Float.valueOf(value.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static <T extends Enum<T>> T getValueAsEnum(Map<?, ?> map, Object key, Class<T> enumType, T defaultValue) {
        Object value = MapUtils.getFirstValue(map, key, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        try {
            return (T)((Enum)value);
        }
        catch (Exception ignored) {
            Class<T> eType = enumType == null && defaultValue != null ? defaultValue.getDeclaringClass() : enumType;
            try {
                return Enum.valueOf(eType, value.toString());
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
    }

    private static class MapEntryComparator
    implements Comparator<Map.Entry<?, ?>> {
        private final Comparator valueComparator;

        MapEntryComparator(Comparator<?> valueComparator) {
            this.valueComparator = valueComparator;
        }

        @Override
        public int compare(Map.Entry<?, ?> e1, Map.Entry<?, ?> e2) {
            int c = 0;
            if (e1 != null && e1.getValue() != null && e2 != null && e2.getValue() != null) {
                Object value1 = e1.getValue();
                Object value2 = e2.getValue();
                if (this.valueComparator != null) {
                    c = this.valueComparator.compare(value1, value2);
                } else if (value1 instanceof Comparable && value2 instanceof Comparable) {
                    c = ((Comparable)value1).compareTo(value2);
                }
            }
            if (c == 0) {
                c = -1;
            }
            return c;
        }
    }
}

