/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.utils;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class PasswordUtils {
    public static final String[] PARTIAL_REGEX_CHECKS = new String[]{".*[a-z]+.*", ".*[A-Z]+.*", ".*[\\d]+.*", ".*[~!@#$%^&*_\\-+=`|\\\\(){}\\[\\]:;\"'<>,.?/]+.*"};
    private static final String SYMBOLS = "~!@#$%&*_-+=(){}[]:;'<>,.?";
    private static final String NUMBERS = "123456789";
    private static final String UPPER_CHARS;
    private static final String LOWER_CHARS;
    private static final char[] PASSWORD_CHARS;
    private static final int PASSWORD_CHARS_LENGTH_WITHOUT_SYMBOLS;
    private static final NumberFormat QUALITY_RESULT_NUMBER_FORMATTER;

    private PasswordUtils() {
    }

    public static String createRandomClearPassword() {
        return PasswordUtils.createRandomClearPassword(true);
    }

    public static String createRandomClearPassword(boolean withSymbols) {
        return PasswordUtils.createRandomClearPassword(14, true, withSymbols);
    }

    public static String createRandomClearPassword(int length) {
        return PasswordUtils.createRandomClearPassword(length, false, true);
    }

    public static String createRandomClearPassword(int length, boolean withVariableLength, boolean withSymbols) {
        char c;
        int n;
        int n2;
        int c2;
        int len;
        Random random = new Random();
        if (length < 0) {
            len = 0;
        } else if (withVariableLength) {
            int varLength = random.nextInt(length + 1);
            len = length + varLength;
        } else {
            len = length;
        }
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = PasswordUtils.findChar(withSymbols, random);
        }
        if (len > 0 && !PasswordUtils.containsLowerCase(chars)) {
            c2 = 108;
            while (c2 == 108) {
                n2 = random.nextInt(LOWER_CHARS.length());
                c2 = LOWER_CHARS.charAt(n2);
            }
            chars[0] = c2;
        }
        if (len > 1 && !PasswordUtils.containsUpperCase(chars)) {
            c2 = 73;
            while (c2 == 73) {
                n2 = random.nextInt(UPPER_CHARS.length());
                c2 = UPPER_CHARS.charAt(n2);
            }
            chars[1] = c2;
        }
        if (len > 2 && !PasswordUtils.containsNumber(chars)) {
            n = random.nextInt(NUMBERS.length());
            chars[2] = c = NUMBERS.charAt(n);
        }
        if (withSymbols && len > 3 && !PasswordUtils.containsSymbol(chars)) {
            n = random.nextInt(SYMBOLS.length());
            chars[3] = c = SYMBOLS.charAt(n);
        }
        return new String(chars);
    }

    public static double getPasswordQuality(String clearPassword, Integer minLength) {
        if (StringUtils.isBlank((CharSequence)clearPassword) || minLength != null && clearPassword.length() < minLength) {
            return 0.0;
        }
        double value = 1.0 / (double)PARTIAL_REGEX_CHECKS.length;
        double result = 0.0;
        for (String PARTIAL_REGEX_CHECK : PARTIAL_REGEX_CHECKS) {
            if (!Pattern.matches(PARTIAL_REGEX_CHECK, clearPassword)) continue;
            result += value;
        }
        return new BigDecimal(QUALITY_RESULT_NUMBER_FORMATTER.format(result)).doubleValue();
    }

    private static char findChar(boolean withSymbols, Random random) {
        int len;
        Random ran = random == null ? new Random() : random;
        int n = ran.nextInt(len = withSymbols ? PASSWORD_CHARS.length : PASSWORD_CHARS_LENGTH_WITHOUT_SYMBOLS);
        char c = PASSWORD_CHARS[n];
        if (c != 'l' && c != 'I' && c != 'O') {
            return c;
        }
        return PasswordUtils.findChar(withSymbols, ran);
    }

    private static boolean containsLowerCase(char[] cs) {
        String s = cs == null ? "" : new String(cs);
        return s.matches(PARTIAL_REGEX_CHECKS[0]);
    }

    private static boolean containsUpperCase(char[] cs) {
        String s = cs == null ? "" : new String(cs);
        return s.matches(PARTIAL_REGEX_CHECKS[1]);
    }

    private static boolean containsNumber(char[] cs) {
        String s = cs == null ? "" : new String(cs);
        return s.matches(PARTIAL_REGEX_CHECKS[2]);
    }

    private static boolean containsSymbol(char[] cs) {
        String s = cs == null ? "" : new String(cs);
        return s.matches(PARTIAL_REGEX_CHECKS[3]);
    }

    static {
        QUALITY_RESULT_NUMBER_FORMATTER = NumberFormat.getNumberInstance(Locale.US);
        StringBuilder sb = new StringBuilder();
        int A = 65;
        int Z = 90;
        for (int i = 65; i <= 90; ++i) {
            sb.append((char)i);
        }
        UPPER_CHARS = sb.toString();
        int a = 97;
        int z = 122;
        for (int i = 97; i <= 122; ++i) {
            sb.append((char)i);
        }
        LOWER_CHARS = sb.toString().substring(UPPER_CHARS.length());
        sb.append(NUMBERS);
        PASSWORD_CHARS_LENGTH_WITHOUT_SYMBOLS = sb.length();
        sb.append(SYMBOLS);
        PASSWORD_CHARS = new char[sb.length()];
        sb.getChars(0, sb.length(), PASSWORD_CHARS, 0);
        QUALITY_RESULT_NUMBER_FORMATTER.setGroupingUsed(false);
        QUALITY_RESULT_NUMBER_FORMATTER.setMaximumFractionDigits(2);
        QUALITY_RESULT_NUMBER_FORMATTER.setMinimumIntegerDigits(1);
    }
}

