/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.utils;

import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.Validate;

public abstract class ResourceBundleUtils {
    private ResourceBundleUtils() {
    }

    public static ResourceBundle getResourceBundle(String baseName, Locale locale) {
        return ResourceBundleUtils.getResourceBundle(baseName, locale, null);
    }

    public static ResourceBundle getResourceBundle(String baseName, Locale locale, ClassLoader classLoader) {
        Validate.notEmpty((CharSequence)baseName, (String)"Base name of the resource bundle must not be null or blank.", (Object[])new Object[0]);
        if (classLoader == null) {
            return ResourceBundle.getBundle(baseName, locale == null ? Locale.getDefault() : locale);
        }
        return ResourceBundle.getBundle(baseName, locale == null ? Locale.getDefault() : locale, classLoader);
    }

    public static String getLocalizedMessage(String baseName, Locale locale, String messageCode, Object[] messageArgs, String defaultMessage) {
        return ResourceBundleUtils.getLocalizedMessage(baseName, locale, null, messageCode, messageArgs, defaultMessage);
    }

    public static String getLocalizedMessage(String baseName, Locale locale, ClassLoader classLoader, String messageCode, Object[] messageArgs, String defaultMessage) {
        ResourceBundle resourceBundle = ResourceBundleUtils.getResourceBundle(baseName, locale, classLoader);
        if (messageCode != null && resourceBundle.containsKey(messageCode)) {
            String msg = resourceBundle.getString(messageCode);
            if (messageArgs == null || messageArgs.length == 0) {
                return msg;
            }
            for (int i = 0; i < messageArgs.length; ++i) {
                String target = "{" + i + "}";
                String replacement = messageArgs[i] == null ? "" : messageArgs[i].toString();
                msg = msg.replace(target, replacement);
            }
            return msg;
        }
        return defaultMessage == null ? "" : defaultMessage;
    }
}

