/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.utils;

import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.bremersee.utils.CaseFormat;

public abstract class TagUtils {
    private TagUtils() {
    }

    private static String doCaseFormat(String text, CaseFormat caseFormat) {
        if (text == null) {
            return null;
        }
        CaseFormat format = caseFormat == null ? CaseFormat.UNTOUCHED : caseFormat;
        switch (format) {
            case TO_LOWER_CASE: {
                return text.toLowerCase();
            }
            case TO_UPPER_CASE: {
                return text.toUpperCase();
            }
        }
        return text;
    }

    public static String[] buildTags(String freeText) {
        return TagUtils.buildTags(freeText, 2);
    }

    public static String[] buildTags(String freeText, int minLengthOfSingleTag) {
        return TagUtils.buildTags(freeText, minLengthOfSingleTag, CaseFormat.UNTOUCHED);
    }

    public static String[] buildTags(String freeText, int minLengthOfSingleTag, CaseFormat caseFormat) {
        int minLen;
        int n = minLen = minLengthOfSingleTag <= 0 ? 1 : minLengthOfSingleTag;
        if (freeText == null || freeText.trim().length() < minLen) {
            return new String[0];
        }
        LinkedList<String> tokens = new LinkedList<String>();
        StringTokenizer tokenizer = new StringTokenizer(freeText);
        while (tokenizer.hasMoreTokens()) {
            String[] plusTokens = tokenizer.nextToken().split(Pattern.quote("+"));
            StringBuilder tokenBuilder = new StringBuilder();
            for (String plusToken : plusTokens) {
                if (tokenBuilder.length() == 0) {
                    tokenBuilder.append(plusToken.trim().replaceAll("[^\\p{L}\\p{Nd}]+", ""));
                    continue;
                }
                tokenBuilder.append(" ").append(plusToken.trim().replaceAll("[^\\p{L}\\p{Nd}]+", ""));
            }
            if (tokenBuilder.length() < minLen) continue;
            tokens.add(TagUtils.doCaseFormat(tokenBuilder.toString(), caseFormat));
        }
        if (tokens.isEmpty()) {
            return new String[]{TagUtils.doCaseFormat(freeText, caseFormat)};
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String buildTagString(String[] tags) {
        return TagUtils.buildTagString(tags, 255);
    }

    public static String buildTagString(String[] tags, int maxLengthOfTagString) {
        if (tags == null || tags.length == 0) {
            return "";
        }
        int maxLen = maxLengthOfTagString < 0 ? 0 : maxLengthOfTagString;
        StringBuilder textBuilder = new StringBuilder();
        for (String tag : tags) {
            String value = textBuilder.length() == 0 ? tag.replaceAll(" ", "+") : " " + tag.replaceAll(" ", "+");
            int len = textBuilder.length() + value.length();
            if (len >= maxLen) break;
            textBuilder.append(value);
        }
        return textBuilder.toString();
    }

    public static String buildTagString(String freeText) {
        return TagUtils.buildTagString(freeText, 2, 255);
    }

    public static String buildTagString(String freeText, int minLengthOfSingleTag) {
        return TagUtils.buildTagString(freeText, minLengthOfSingleTag, 255);
    }

    public static String buildTagString(String freeText, int minLengthOfSingleTag, CaseFormat caseFormat) {
        return TagUtils.buildTagString(freeText, minLengthOfSingleTag, 255, caseFormat);
    }

    public static String buildTagString(String freeText, int minLengthOfSingleTag, int maxLengthOfTagString) {
        return TagUtils.buildTagString(freeText, minLengthOfSingleTag, maxLengthOfTagString, CaseFormat.UNTOUCHED);
    }

    public static String buildTagString(String freeText, int minLengthOfSingleTag, int maxLengthOfTagString, CaseFormat caseFormat) {
        String[] tags = TagUtils.buildTags(freeText, minLengthOfSingleTag, caseFormat);
        return TagUtils.buildTagString(tags, maxLengthOfTagString);
    }
}

