/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public abstract class TimeZoneUtils {
    private static final Map<String, String> TIME_ZONE_IDS = new HashMap<String, String>();

    private TimeZoneUtils() {
    }

    public static String validateTimeZoneId(String timeZoneId) {
        return TimeZoneUtils.validateTimeZoneId(timeZoneId, null);
    }

    public static String validateTimeZoneId(String timeZoneId, String defaultTimeZoneId) {
        String id;
        if (StringUtils.isNotBlank((CharSequence)timeZoneId) && (id = TIME_ZONE_IDS.get(timeZoneId.toLowerCase())) != null) {
            return id;
        }
        if (defaultTimeZoneId == null) {
            return TimeZone.getDefault().getID();
        }
        return TimeZoneUtils.validateTimeZoneId(defaultTimeZoneId, null);
    }

    static {
        for (String id : TimeZone.getAvailableIDs()) {
            TIME_ZONE_IDS.put(id.toLowerCase(), id);
        }
    }
}

