/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.exception.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.List;
import lombok.Generated;

@Schema(description="The handler where the exception occurred.")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Handler
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Schema(description="The class name of the handler.")
    private String className;
    @Schema(description="The method name of the handler.")
    private String methodName;
    @JsonProperty(value="methodParameterTypes")
    @JacksonXmlElementWrapper(localName="methodParameterTypes")
    @JacksonXmlProperty(localName="methodParameterType")
    @Schema(description="The method parameters.")
    private List<String> methodParameterTypes;

    protected Handler(String className, String methodName, List<String> methodParameterTypes) {
        this.className = className;
        this.methodName = methodName;
        this.methodParameterTypes = methodParameterTypes;
    }

    @Generated
    public static HandlerBuilder builder() {
        return new HandlerBuilder();
    }

    @Generated
    public HandlerBuilder toBuilder() {
        return new HandlerBuilder().className(this.className).methodName(this.methodName).methodParameterTypes(this.methodParameterTypes);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Handler)) {
            return false;
        }
        Handler other = (Handler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        String this$methodName = this.getMethodName();
        String other$methodName = other.getMethodName();
        if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
            return false;
        }
        List<String> this$methodParameterTypes = this.getMethodParameterTypes();
        List<String> other$methodParameterTypes = other.getMethodParameterTypes();
        return !(this$methodParameterTypes == null ? other$methodParameterTypes != null : !((Object)this$methodParameterTypes).equals(other$methodParameterTypes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Handler;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        String $methodName = this.getMethodName();
        result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
        List<String> $methodParameterTypes = this.getMethodParameterTypes();
        result = result * 59 + ($methodParameterTypes == null ? 43 : ((Object)$methodParameterTypes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Handler(className=" + this.getClassName() + ", methodName=" + this.getMethodName() + ", methodParameterTypes=" + this.getMethodParameterTypes() + ")";
    }

    @Generated
    public String getClassName() {
        return this.className;
    }

    @Generated
    public String getMethodName() {
        return this.methodName;
    }

    @Generated
    public List<String> getMethodParameterTypes() {
        return this.methodParameterTypes;
    }

    @Generated
    public void setClassName(String className) {
        this.className = className;
    }

    @Generated
    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @JsonProperty(value="methodParameterTypes")
    @JacksonXmlElementWrapper(localName="methodParameterTypes")
    @JacksonXmlProperty(localName="methodParameterType")
    @Generated
    public void setMethodParameterTypes(List<String> methodParameterTypes) {
        this.methodParameterTypes = methodParameterTypes;
    }

    @Generated
    public Handler() {
    }

    @Generated
    public static class HandlerBuilder {
        @Generated
        private String className;
        @Generated
        private String methodName;
        @Generated
        private List<String> methodParameterTypes;

        @Generated
        HandlerBuilder() {
        }

        @Generated
        public HandlerBuilder className(String className) {
            this.className = className;
            return this;
        }

        @Generated
        public HandlerBuilder methodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        @Generated
        public HandlerBuilder methodParameterTypes(List<String> methodParameterTypes) {
            this.methodParameterTypes = methodParameterTypes;
            return this;
        }

        @Generated
        public Handler build() {
            return new Handler(this.className, this.methodName, this.methodParameterTypes);
        }

        @Generated
        public String toString() {
            return "Handler.HandlerBuilder(className=" + this.className + ", methodName=" + this.methodName + ", methodParameterTypes=" + this.methodParameterTypes + ")";
        }
    }
}

