/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.exception.model;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.bremersee.exception.model.Handler;
import org.bremersee.exception.model.StackTraceItem;

@Schema(description="The serialized exception.")
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class RestApiException
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Schema(description="The id of the exception.")
    private String id;
    @Schema(description="The timestamp.")
    private OffsetDateTime timestamp;
    @Schema(description="The http status code.")
    private Integer status;
    @Schema(description="The http error message.")
    private String error;
    @Schema(description="A service specific error code.")
    private String errorCode;
    @Schema(description="Determines whether the error code is inherited from the cause or not.")
    private Boolean errorCodeInherited;
    @Schema(description="A human readable exception message.")
    private String message;
    @Schema(description="The class name of the exception.")
    private String exception;
    @Schema(description="The name of the application.")
    private String application;
    @Schema(description="The request path.")
    private String path;
    @Schema(description="The handler.")
    private Handler handler;
    @Schema(description="The stack trace.")
    private List<StackTraceItem> stackTrace;
    @Schema(description="The cause.")
    private RestApiException cause;
    @Schema(hidden=true)
    @JsonIgnore
    private final Map<String, Object> furtherDetails = new LinkedHashMap<String, Object>();

    protected RestApiException(String id, OffsetDateTime timestamp, Integer status, String error, String errorCode, Boolean errorCodeInherited, String message, String exception, String application, String path, Handler handler, List<StackTraceItem> stackTrace, RestApiException cause, Map<String, Object> furtherDetails) {
        this.id = id;
        this.timestamp = timestamp;
        this.status = status;
        this.error = error;
        this.errorCode = errorCode;
        this.errorCodeInherited = errorCodeInherited;
        this.message = message;
        this.exception = exception;
        this.application = application;
        this.path = path;
        this.handler = handler;
        this.stackTrace = stackTrace;
        this.cause = cause;
        if (Objects.nonNull(furtherDetails)) {
            this.furtherDetails.putAll(furtherDetails);
        }
    }

    public Boolean getErrorCodeInherited() {
        return Boolean.TRUE.equals(this.errorCodeInherited);
    }

    @JsonAnySetter
    public void furtherDetails(String name, Object value) {
        if (Objects.nonNull(name) && !name.isBlank()) {
            this.furtherDetails.put(name, value);
        }
    }

    @JsonAnySetter
    public Map<String, Object> furtherDetails() {
        return this.furtherDetails;
    }

    @Generated
    public static RestApiExceptionBuilder builder() {
        return new RestApiExceptionBuilder();
    }

    @Generated
    public RestApiExceptionBuilder toBuilder() {
        return new RestApiExceptionBuilder().id(this.id).timestamp(this.timestamp).status(this.status).error(this.error).errorCode(this.errorCode).errorCodeInherited(this.errorCodeInherited).message(this.message).exception(this.exception).application(this.application).path(this.path).handler(this.handler).stackTrace(this.stackTrace).cause(this.cause).furtherDetails(this.furtherDetails);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestApiException)) {
            return false;
        }
        RestApiException other = (RestApiException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Boolean this$errorCodeInherited = this.getErrorCodeInherited();
        Boolean other$errorCodeInherited = other.getErrorCodeInherited();
        if (this$errorCodeInherited == null ? other$errorCodeInherited != null : !((Object)this$errorCodeInherited).equals(other$errorCodeInherited)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        OffsetDateTime this$timestamp = this.getTimestamp();
        OffsetDateTime other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        String this$errorCode = this.getErrorCode();
        String other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$exception = this.getException();
        String other$exception = other.getException();
        if (this$exception == null ? other$exception != null : !this$exception.equals(other$exception)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        Handler this$handler = this.getHandler();
        Handler other$handler = other.getHandler();
        if (this$handler == null ? other$handler != null : !((Object)this$handler).equals(other$handler)) {
            return false;
        }
        List<StackTraceItem> this$stackTrace = this.getStackTrace();
        List<StackTraceItem> other$stackTrace = other.getStackTrace();
        if (this$stackTrace == null ? other$stackTrace != null : !((Object)this$stackTrace).equals(other$stackTrace)) {
            return false;
        }
        RestApiException this$cause = this.getCause();
        RestApiException other$cause = other.getCause();
        return !(this$cause == null ? other$cause != null : !((Object)this$cause).equals(other$cause));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RestApiException;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Boolean $errorCodeInherited = this.getErrorCodeInherited();
        result = result * 59 + ($errorCodeInherited == null ? 43 : ((Object)$errorCodeInherited).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        OffsetDateTime $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        String $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        Handler $handler = this.getHandler();
        result = result * 59 + ($handler == null ? 43 : ((Object)$handler).hashCode());
        List<StackTraceItem> $stackTrace = this.getStackTrace();
        result = result * 59 + ($stackTrace == null ? 43 : ((Object)$stackTrace).hashCode());
        RestApiException $cause = this.getCause();
        result = result * 59 + ($cause == null ? 43 : ((Object)$cause).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RestApiException(id=" + this.getId() + ", timestamp=" + this.getTimestamp() + ", status=" + this.getStatus() + ", error=" + this.getError() + ", errorCode=" + this.getErrorCode() + ", errorCodeInherited=" + this.getErrorCodeInherited() + ", message=" + this.getMessage() + ", exception=" + this.getException() + ", application=" + this.getApplication() + ", path=" + this.getPath() + ", handler=" + this.getHandler() + ", stackTrace=" + this.getStackTrace() + ", cause=" + this.getCause() + ", furtherDetails=" + this.furtherDetails + ")";
    }

    @Generated
    public RestApiException() {
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public void setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public void setStatus(Integer status) {
        this.status = status;
    }

    @Generated
    public String getError() {
        return this.error;
    }

    @Generated
    public void setError(String error) {
        this.error = error;
    }

    @Generated
    public String getErrorCode() {
        return this.errorCode;
    }

    @Generated
    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    @Generated
    public void setErrorCodeInherited(Boolean errorCodeInherited) {
        this.errorCodeInherited = errorCodeInherited;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public String getException() {
        return this.exception;
    }

    @Generated
    public void setException(String exception) {
        this.exception = exception;
    }

    @Generated
    public String getApplication() {
        return this.application;
    }

    @Generated
    public void setApplication(String application) {
        this.application = application;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public Handler getHandler() {
        return this.handler;
    }

    @Generated
    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    @Generated
    public List<StackTraceItem> getStackTrace() {
        return this.stackTrace;
    }

    @Generated
    public void setStackTrace(List<StackTraceItem> stackTrace) {
        this.stackTrace = stackTrace;
    }

    @Generated
    public RestApiException getCause() {
        return this.cause;
    }

    @Generated
    public void setCause(RestApiException cause) {
        this.cause = cause;
    }

    @Generated
    public static class RestApiExceptionBuilder {
        @Generated
        private String id;
        @Generated
        private OffsetDateTime timestamp;
        @Generated
        private Integer status;
        @Generated
        private String error;
        @Generated
        private String errorCode;
        @Generated
        private Boolean errorCodeInherited;
        @Generated
        private String message;
        @Generated
        private String exception;
        @Generated
        private String application;
        @Generated
        private String path;
        @Generated
        private Handler handler;
        @Generated
        private List<StackTraceItem> stackTrace;
        @Generated
        private RestApiException cause;
        @Generated
        private Map<String, Object> furtherDetails;

        @Generated
        RestApiExceptionBuilder() {
        }

        @Generated
        public RestApiExceptionBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public RestApiExceptionBuilder timestamp(OffsetDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Generated
        public RestApiExceptionBuilder status(Integer status) {
            this.status = status;
            return this;
        }

        @Generated
        public RestApiExceptionBuilder error(String error) {
            this.error = error;
            return this;
        }

        @Generated
        public RestApiExceptionBuilder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Generated
        public RestApiExceptionBuilder errorCodeInherited(Boolean errorCodeInherited) {
            this.errorCodeInherited = errorCodeInherited;
            return this;
        }

        @Generated
        public RestApiExceptionBuilder message(String message) {
            this.message = message;
            return this;
        }

        @Generated
        public RestApiExceptionBuilder exception(String exception) {
            this.exception = exception;
            return this;
        }

        @Generated
        public RestApiExceptionBuilder application(String application) {
            this.application = application;
            return this;
        }

        @Generated
        public RestApiExceptionBuilder path(String path) {
            this.path = path;
            return this;
        }

        @Generated
        public RestApiExceptionBuilder handler(Handler handler) {
            this.handler = handler;
            return this;
        }

        @Generated
        public RestApiExceptionBuilder stackTrace(List<StackTraceItem> stackTrace) {
            this.stackTrace = stackTrace;
            return this;
        }

        @Generated
        public RestApiExceptionBuilder cause(RestApiException cause) {
            this.cause = cause;
            return this;
        }

        @Generated
        public RestApiExceptionBuilder furtherDetails(Map<String, Object> furtherDetails) {
            this.furtherDetails = furtherDetails;
            return this;
        }

        @Generated
        public RestApiException build() {
            return new RestApiException(this.id, this.timestamp, this.status, this.error, this.errorCode, this.errorCodeInherited, this.message, this.exception, this.application, this.path, this.handler, this.stackTrace, this.cause, this.furtherDetails);
        }

        @Generated
        public String toString() {
            return "RestApiException.RestApiExceptionBuilder(id=" + this.id + ", timestamp=" + this.timestamp + ", status=" + this.status + ", error=" + this.error + ", errorCode=" + this.errorCode + ", errorCodeInherited=" + this.errorCodeInherited + ", message=" + this.message + ", exception=" + this.exception + ", application=" + this.application + ", path=" + this.path + ", handler=" + this.handler + ", stackTrace=" + this.stackTrace + ", cause=" + this.cause + ", furtherDetails=" + this.furtherDetails + ")";
        }
    }
}

