/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.exception.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import lombok.Generated;

@Schema(description="A stack trace element of an exception.")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class StackTraceItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Schema(description="The declaring class.")
    private String declaringClass;
    @Schema(description="The method name.")
    private String methodName;
    @Schema(description="The file name.")
    private String fileName;
    @Schema(description="The line number.")
    private Integer lineNumber;

    protected StackTraceItem(String declaringClass, String methodName, String fileName, Integer lineNumber) {
        this.declaringClass = declaringClass;
        this.methodName = methodName;
        this.fileName = fileName;
        this.lineNumber = lineNumber;
    }

    @Generated
    public static StackTraceItemBuilder builder() {
        return new StackTraceItemBuilder();
    }

    @Generated
    public StackTraceItemBuilder toBuilder() {
        return new StackTraceItemBuilder().declaringClass(this.declaringClass).methodName(this.methodName).fileName(this.fileName).lineNumber(this.lineNumber);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StackTraceItem)) {
            return false;
        }
        StackTraceItem other = (StackTraceItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$lineNumber = this.getLineNumber();
        Integer other$lineNumber = other.getLineNumber();
        if (this$lineNumber == null ? other$lineNumber != null : !((Object)this$lineNumber).equals(other$lineNumber)) {
            return false;
        }
        String this$declaringClass = this.getDeclaringClass();
        String other$declaringClass = other.getDeclaringClass();
        if (this$declaringClass == null ? other$declaringClass != null : !this$declaringClass.equals(other$declaringClass)) {
            return false;
        }
        String this$methodName = this.getMethodName();
        String other$methodName = other.getMethodName();
        if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        return !(this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StackTraceItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $lineNumber = this.getLineNumber();
        result = result * 59 + ($lineNumber == null ? 43 : ((Object)$lineNumber).hashCode());
        String $declaringClass = this.getDeclaringClass();
        result = result * 59 + ($declaringClass == null ? 43 : $declaringClass.hashCode());
        String $methodName = this.getMethodName();
        result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "StackTraceItem(declaringClass=" + this.getDeclaringClass() + ", methodName=" + this.getMethodName() + ", fileName=" + this.getFileName() + ", lineNumber=" + this.getLineNumber() + ")";
    }

    @Generated
    public String getDeclaringClass() {
        return this.declaringClass;
    }

    @Generated
    public String getMethodName() {
        return this.methodName;
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public Integer getLineNumber() {
        return this.lineNumber;
    }

    @Generated
    public void setDeclaringClass(String declaringClass) {
        this.declaringClass = declaringClass;
    }

    @Generated
    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @Generated
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Generated
    public void setLineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Generated
    public StackTraceItem() {
    }

    @Generated
    public static class StackTraceItemBuilder {
        @Generated
        private String declaringClass;
        @Generated
        private String methodName;
        @Generated
        private String fileName;
        @Generated
        private Integer lineNumber;

        @Generated
        StackTraceItemBuilder() {
        }

        @Generated
        public StackTraceItemBuilder declaringClass(String declaringClass) {
            this.declaringClass = declaringClass;
            return this;
        }

        @Generated
        public StackTraceItemBuilder methodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        @Generated
        public StackTraceItemBuilder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        @Generated
        public StackTraceItemBuilder lineNumber(Integer lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        @Generated
        public StackTraceItem build() {
            return new StackTraceItem(this.declaringClass, this.methodName, this.fileName, this.lineNumber);
        }

        @Generated
        public String toString() {
            return "StackTraceItem.StackTraceItemBuilder(declaringClass=" + this.declaringClass + ", methodName=" + this.methodName + ", fileName=" + this.fileName + ", lineNumber=" + this.lineNumber + ")";
        }
    }
}

