/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.geojson;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.bremersee.geojson.GeoJsonLinkedCrs;
import org.bremersee.geojson.GeoJsonNamedCrs;

@Schema(description="The coordinate reference system (CRS) of a GeoJSON object.")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=GeoJsonLinkedCrs.class, name="link"), @JsonSubTypes.Type(value=GeoJsonNamedCrs.class, name="name")})
public class AbstractGeoJsonCrs
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Schema(description="The properties.")
    @JsonProperty(value="properties")
    private Map<String, Object> properties = new LinkedHashMap<String, Object>();

    protected final Map<String, Object> getProperties() {
        return this.properties;
    }

    protected final void setProperties(Map<String, Object> properties) {
        this.properties = Objects.requireNonNullElseGet(properties, LinkedHashMap::new);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractGeoJsonCrs)) {
            return false;
        }
        AbstractGeoJsonCrs that = (AbstractGeoJsonCrs)o;
        if (this.properties == that.properties) {
            return true;
        }
        if (this.properties == null || that.properties == null) {
            return false;
        }
        return Objects.equals(new TreeMap<String, Object>(this.properties), new TreeMap<String, Object>(that.properties));
    }

    public int hashCode() {
        return Objects.hash(this.properties);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " {properties=" + this.properties + "}";
    }
}

