/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.geojson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Arrays;
import java.util.Objects;
import org.bremersee.common.model.UnknownAware;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={})
@JsonTypeName(value="Feature")
@JsonPropertyOrder(value={"id", "bbox", "geometry", "properties"})
public abstract class AbstractGeoJsonFeature<G, P>
extends UnknownAware {
    @JsonIgnore
    private double[] bbox = null;
    @JsonIgnore
    private P properties = null;

    protected AbstractGeoJsonFeature() {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="id")
    public abstract String getId();

    @JsonProperty(value="id")
    public abstract void setId(String var1);

    @JsonProperty(value="geometry")
    public abstract G getGeometry();

    @JsonProperty(value="geometry")
    public abstract void setGeometry(G var1);

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="bbox")
    public double[] getBbox() {
        return this.bbox;
    }

    @JsonProperty(value="bbox")
    public void setBbox(double[] bbox) {
        if (bbox != null && bbox.length != 4 && bbox.length != 6) {
            throw new IllegalArgumentException("Bounding box must be null or must have a length of four or six.");
        }
        this.bbox = bbox;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="properties")
    public P getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(P properties) {
        this.properties = properties;
    }

    public String toString() {
        return "GeoJsonFeature {id='" + this.getId() + "', geometry=" + this.getGeometry() + ", bbox=" + Arrays.toString(this.getBbox()) + ", properties=" + this.getProperties() + "}";
    }

    public int hashCode() {
        int result = Objects.hash(this.getId(), this.getGeometry(), this.getProperties());
        result = 31 * result + Arrays.hashCode(this.getBbox());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractGeoJsonFeature)) {
            return false;
        }
        AbstractGeoJsonFeature that = (AbstractGeoJsonFeature)((Object)o);
        return Objects.equals(this.getId(), that.getId()) && this.equals(this.getGeometry(), that.getGeometry()) && Arrays.equals(this.getBbox(), that.getBbox()) && Objects.equals(this.getProperties(), that.getProperties());
    }

    protected abstract boolean equals(G var1, Object var2);
}

