/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.geojson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bremersee.geojson.AbstractGeoJsonFeature;
import org.bremersee.geojson.GeometryDeserializer;
import org.bremersee.geojson.GeometrySerializer;
import org.bremersee.geojson.model.Geometry;
import org.bremersee.geojson.utils.GeometryUtils;

@Schema(description="A GeoJSON object with type 'Feature'.")
public class GeoJsonFeature
extends AbstractGeoJsonFeature<org.locationtech.jts.geom.Geometry, Map<String, Object>>
implements Serializable {
    private static final long serialVersionUID = 2L;
    @JsonIgnore
    private String id;
    @JsonIgnore
    private org.locationtech.jts.geom.Geometry geometry;

    public GeoJsonFeature() {
    }

    public GeoJsonFeature(String id, org.locationtech.jts.geom.Geometry geometry, boolean calculateBounds, Map<String, Object> properties) {
        if (id != null && id.trim().length() > 0) {
            this.setId(id);
        }
        this.setGeometry(geometry);
        if (calculateBounds && geometry != null) {
            this.setBbox(GeometryUtils.getBoundingBox(geometry));
        }
        if (properties != null) {
            this.getProperties().putAll(properties);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    @Schema(description="GeoJSON", implementation=Geometry.class)
    @JsonSerialize(using=GeometrySerializer.class)
    public org.locationtech.jts.geom.Geometry getGeometry() {
        return this.geometry;
    }

    @Override
    @Schema(description="GeoJSON", implementation=Geometry.class)
    @JsonDeserialize(using=GeometryDeserializer.class)
    public void setGeometry(org.locationtech.jts.geom.Geometry geometry) {
        this.geometry = geometry;
    }

    @Override
    public Map<String, Object> getProperties() {
        if (super.getProperties() == null) {
            super.setProperties(new LinkedHashMap());
        }
        return (Map)super.getProperties();
    }

    @Override
    protected boolean equals(org.locationtech.jts.geom.Geometry g1, Object g2) {
        if (g1 == g2) {
            return true;
        }
        if (g1 != null && g2 instanceof org.locationtech.jts.geom.Geometry) {
            return GeometryUtils.equals(g1, (org.locationtech.jts.geom.Geometry)g2);
        }
        return false;
    }
}

