/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.geojson;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.bremersee.geojson.AbstractGeoJsonFeatureCollection;
import org.bremersee.geojson.GeoJsonFeature;
import org.bremersee.geojson.utils.GeometryUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;

public class GeoJsonFeatureCollection
extends AbstractGeoJsonFeatureCollection<GeoJsonFeature>
implements Serializable {
    private static final long serialVersionUID = 2L;

    public GeoJsonFeatureCollection() {
    }

    public GeoJsonFeatureCollection(Collection<? extends GeoJsonFeature> features, boolean calculateBounds) {
        if (features != null) {
            this.getFeatures().addAll(features);
            if (calculateBounds) {
                ArrayList<Geometry> glist = new ArrayList<Geometry>();
                for (GeoJsonFeature geoJsonFeature : features) {
                    glist.add(geoJsonFeature.getGeometry());
                }
                Geometry[] geometries = glist.toArray(new Geometry[0]);
                GeometryCollection geometryCollection = new GeometryCollection(geometries, new GeometryFactory());
                this.setBbox(GeometryUtils.getBoundingBox((Geometry)geometryCollection));
            }
        }
    }
}

