/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.geojson;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bremersee.geojson.GeometryDeserializer;
import org.bremersee.geojson.GeometrySerializer;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GeoJsonObjectMapperModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;

    public GeoJsonObjectMapperModule() {
        this(null);
    }

    public GeoJsonObjectMapperModule(GeometryFactory geometryFactory) {
        super("GeoJsonModule", GeoJsonObjectMapperModule.getVersion(), GeoJsonObjectMapperModule.getDeserializers(geometryFactory), GeoJsonObjectMapperModule.getSerializers());
    }

    public static void configure(ObjectMapper objectMapper) {
        GeoJsonObjectMapperModule.configure(objectMapper, null);
    }

    public static void configure(ObjectMapper objectMapper, GeometryFactory geometryFactory) {
        if (objectMapper != null) {
            objectMapper.registerModule((Module)new GeoJsonObjectMapperModule(geometryFactory));
        }
    }

    private static Version getVersion() {
        int defaultMajor = 2;
        boolean defaultMinor = false;
        int defaultPatchLevel = 8;
        String defaultSnapshotInfo = "SNAPSHOT";
        int major = 2;
        int minor = 0;
        int patchLevel = 8;
        String snapshotInfo = "SNAPSHOT";
        String version = GeoJsonObjectMapperModule.class.getPackage().getImplementationVersion();
        if (version != null) {
            try {
                int i = version.indexOf(45);
                if (i < 0) {
                    snapshotInfo = null;
                } else {
                    snapshotInfo = version.substring(i + 1);
                    String[] a = version.substring(0, i).split(Pattern.quote("."));
                    major = Integer.parseInt(a[0]);
                    minor = Integer.parseInt(a[1]);
                    patchLevel = Integer.parseInt(a[2]);
                }
            }
            catch (RuntimeException e) {
                major = 2;
                minor = 0;
                patchLevel = 8;
                snapshotInfo = "SNAPSHOT";
            }
        }
        return new Version(major, minor, patchLevel, snapshotInfo, "org.bremersee", "geojson");
    }

    private static Map<Class<?>, JsonDeserializer<?>> getDeserializers(GeometryFactory geometryFactory) {
        GeometryFactory gf = geometryFactory == null ? new GeometryFactory() : geometryFactory;
        HashMap map = new HashMap();
        map.put(Geometry.class, (JsonDeserializer<?>)new GeometryDeserializer(gf));
        map.put(Point.class, (JsonDeserializer<?>)new GeometryDeserializer(gf));
        map.put(LineString.class, (JsonDeserializer<?>)new GeometryDeserializer(gf));
        map.put(Polygon.class, (JsonDeserializer<?>)new GeometryDeserializer(gf));
        map.put(MultiPoint.class, (JsonDeserializer<?>)new GeometryDeserializer(gf));
        map.put(MultiLineString.class, (JsonDeserializer<?>)new GeometryDeserializer(gf));
        map.put(MultiPolygon.class, (JsonDeserializer<?>)new GeometryDeserializer(gf));
        map.put(GeometryCollection.class, (JsonDeserializer<?>)new GeometryDeserializer(gf));
        return map;
    }

    private static List<JsonSerializer<?>> getSerializers() {
        ArrayList list = new ArrayList();
        list.add((JsonSerializer<?>)new GeometrySerializer());
        return list;
    }
}

