/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.geojson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bremersee.geojson.utils.ConvertHelper;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class GeometryDeserializer
extends StdDeserializer<Geometry> {
    private static final long serialVersionUID = 2L;
    private final ConvertHelper convertHelper;

    public GeometryDeserializer() {
        this(null);
    }

    public GeometryDeserializer(GeometryFactory geometryFactory) {
        super(Geometry.class);
        this.convertHelper = new ConvertHelper(geometryFactory);
    }

    public Geometry deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken currentToken;
        String type = null;
        ArrayList<Object> coordinates = new ArrayList<Object>();
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        while ((currentToken = jp.nextValue()) != null) {
            if (JsonToken.VALUE_STRING.equals((Object)currentToken)) {
                if (!"type".equals(jp.getCurrentName())) continue;
                type = jp.getText();
                continue;
            }
            if (JsonToken.START_ARRAY.equals((Object)currentToken)) {
                if ("coordinates".equals(jp.getCurrentName())) {
                    this.parseCoordinates(0, coordinates, jp, ctxt);
                    continue;
                }
                if (!"geometries".equals(jp.getCurrentName())) continue;
                geometries.addAll(this.parseGeometries(jp, ctxt));
                continue;
            }
            if (!JsonToken.END_OBJECT.equals((Object)currentToken)) continue;
        }
        if ("GeometryCollection".equals(type)) {
            return this.convertHelper.createGeometryCollection(geometries);
        }
        return this.createGeometry(type, coordinates);
    }

    private void parseCoordinates(int depth, List<Object> coordinates, JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken currentToken;
        while ((currentToken = jp.nextValue()) != null && !JsonToken.END_ARRAY.equals((Object)currentToken)) {
            if (JsonToken.START_ARRAY.equals((Object)currentToken)) {
                ArrayList<Object> list = new ArrayList<Object>();
                this.parseCoordinates(depth + 1, list, jp, ctxt);
                coordinates.add(list);
                continue;
            }
            if (JsonToken.VALUE_NUMBER_FLOAT.equals((Object)currentToken)) {
                coordinates.add(jp.getDoubleValue());
                continue;
            }
            if (!JsonToken.VALUE_NUMBER_INT.equals((Object)currentToken)) continue;
            long v = jp.getLongValue();
            double d = v;
            coordinates.add(d);
        }
    }

    private List<Geometry> parseGeometries(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken currentToken;
        String type = null;
        ArrayList<Object> coordinates = new ArrayList<Object>();
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        while ((currentToken = jsonParser.nextValue()) != null) {
            if (JsonToken.END_OBJECT.equals((Object)currentToken) && type != null && !coordinates.isEmpty()) {
                geometries.add(this.createGeometry(type, coordinates));
                type = null;
                coordinates = new ArrayList();
                continue;
            }
            if (JsonToken.VALUE_STRING.equals((Object)currentToken) && "type".equals(jsonParser.getCurrentName())) {
                type = jsonParser.getText();
                continue;
            }
            if (JsonToken.START_ARRAY.equals((Object)currentToken) && "coordinates".equals(jsonParser.getCurrentName())) {
                this.parseCoordinates(0, coordinates, jsonParser, deserializationContext);
                continue;
            }
            if (!JsonToken.END_ARRAY.equals((Object)currentToken)) continue;
            break;
        }
        return geometries;
    }

    private Geometry createGeometry(String type, List<Object> coordinates) {
        if ("Point".equals(type)) {
            return this.convertHelper.createPoint(coordinates);
        }
        if ("LineString".equals(type)) {
            return this.convertHelper.createLineString(coordinates);
        }
        if ("Polygon".equals(type)) {
            return this.convertHelper.createPolygon(coordinates);
        }
        if ("MultiPoint".equals(type)) {
            return this.convertHelper.createMultiPoint(coordinates);
        }
        if ("MultiLineString".equals(type)) {
            return this.convertHelper.createMultiLineString(coordinates);
        }
        if ("MultiPolygon".equals(type)) {
            return this.convertHelper.createMultiPolygon(coordinates);
        }
        throw new IllegalArgumentException("Geometry type [" + type + "] is unsupported.");
    }
}

