/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.geojson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import java.io.Serializable;
import org.bremersee.geojson.GeometryDeserializer;
import org.bremersee.geojson.GeometrySerializer;
import org.bremersee.geojson.utils.GeometryUtils;
import org.locationtech.jts.geom.Geometry;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class GeometryWrapper
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @JsonIgnore
    private Geometry geometry;

    public GeometryWrapper() {
    }

    public GeometryWrapper(Geometry geometry) {
        this.setGeometry(geometry);
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    public String toString() {
        return "GeoJsonGeometry [geometry=" + this.geometry + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.geometry == null ? 0 : this.geometry.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeometryWrapper other = (GeometryWrapper)obj;
        if (this.geometry == null) {
            return other.geometry == null;
        }
        return GeometryUtils.equals(this.geometry, other.geometry);
    }

    public GeometryWrapper clone() {
        if (this.geometry == null) {
            return new GeometryWrapper();
        }
        return new GeometryWrapper(this.geometry.copy());
    }

    protected static class Deserializer
    extends JsonDeserializer<GeometryWrapper> {
        private final GeometryDeserializer geometryDeserializer = new GeometryDeserializer();

        protected Deserializer() {
        }

        public GeometryWrapper deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
            return this.deserialize(jp, ctxt);
        }

        public GeometryWrapper deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            Geometry geometry = this.geometryDeserializer.deserialize(jp, ctxt);
            return new GeometryWrapper(geometry);
        }
    }

    protected static class Serializer
    extends JsonSerializer<GeometryWrapper> {
        private final GeometrySerializer geometrySerializer = new GeometrySerializer();

        protected Serializer() {
        }

        public void serializeWithType(GeometryWrapper value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
            this.serialize(value, gen, provider);
        }

        public void serialize(GeometryWrapper value, JsonGenerator jgen, SerializerProvider prov) throws IOException {
            if (value == null) {
                jgen.writeNull();
            } else {
                this.geometrySerializer.serialize(value.geometry, jgen, prov);
            }
        }
    }
}

