/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.geojson.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.math.BigDecimal;
import lombok.Generated;
import org.bremersee.geojson.model.LatLonAware;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Point;

@Schema(description="WGS84 position with lat and lon.")
@JsonIgnoreProperties(ignoreUnknown=true)
public class LatLon
implements LatLonAware,
Serializable {
    private static final long serialVersionUID = 1L;
    @Schema(description="The latitude.")
    private BigDecimal lat;
    @Schema(description="The longitude.")
    private BigDecimal lon;

    @JsonCreator
    public LatLon(@JsonProperty(value="lat") BigDecimal lat, @JsonProperty(value="lon") BigDecimal lon) {
        this.lat = lat;
        this.lon = lon;
    }

    public LatLon(LatLonAware latLonAware) {
        if (latLonAware != null) {
            this.lat = latLonAware.getLatitude();
            this.lon = latLonAware.getLongitude();
        }
    }

    public LatLon(Point point) {
        if (point != null) {
            this.lat = BigDecimal.valueOf(point.getY());
            this.lon = BigDecimal.valueOf(point.getX());
        }
    }

    public LatLon(Coordinate coordinate) {
        if (coordinate != null) {
            this.lat = BigDecimal.valueOf(coordinate.getY());
            this.lon = BigDecimal.valueOf(coordinate.getX());
        }
    }

    @Override
    @JsonProperty(value="lat")
    public BigDecimal getLatitude() {
        return this.lat;
    }

    @Override
    @JsonProperty(value="lon")
    public BigDecimal getLongitude() {
        return this.lon;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LatLon)) {
            return false;
        }
        LatLon other = (LatLon)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigDecimal this$lat = this.lat;
        BigDecimal other$lat = other.lat;
        if (this$lat == null ? other$lat != null : !((Object)this$lat).equals(other$lat)) {
            return false;
        }
        BigDecimal this$lon = this.lon;
        BigDecimal other$lon = other.lon;
        return !(this$lon == null ? other$lon != null : !((Object)this$lon).equals(other$lon));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LatLon;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $lat = this.lat;
        result = result * 59 + ($lat == null ? 43 : ((Object)$lat).hashCode());
        BigDecimal $lon = this.lon;
        result = result * 59 + ($lon == null ? 43 : ((Object)$lon).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LatLon(lat=" + this.lat + ", lon=" + this.lon + ")";
    }
}

