/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.geojson.model;

import java.math.BigDecimal;
import org.bremersee.geojson.model.LatLon;
import org.bremersee.geojson.utils.GeometryUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Point;

public interface LatLonAware {
    public BigDecimal getLatitude();

    public BigDecimal getLongitude();

    default public boolean hasValues() {
        return this.getLatitude() != null && this.getLongitude() != null;
    }

    default public Point toPoint() {
        return this.hasValues() ? GeometryUtils.createPoint(this.getLongitude(), this.getLatitude()) : null;
    }

    default public Coordinate toCoordinate() {
        return this.hasValues() ? GeometryUtils.createCoordinate(this.getLongitude(), this.getLatitude()) : null;
    }

    default public String toLatLonString() {
        return this.hasValues() ? this.getLatitude().toPlainString() + "," + this.getLongitude().toPlainString() : "";
    }

    default public String toLonLatString() {
        return this.hasValues() ? this.getLongitude().toPlainString() + "," + this.getLatitude().toPlainString() : "";
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static class BuilderImpl
    implements Builder {
        private BigDecimal latitude;
        private BigDecimal longitude;

        @Override
        public Builder from(LatLonAware latLonAware) {
            if (latLonAware != null) {
                this.latitude = latLonAware.getLatitude();
                this.longitude = latLonAware.getLongitude();
            }
            return this;
        }

        @Override
        public Builder latitude(BigDecimal latitude) {
            this.latitude = latitude;
            return this;
        }

        @Override
        public Builder latitude(double latitude) {
            this.latitude = BigDecimal.valueOf(latitude);
            return this;
        }

        @Override
        public Builder longitude(BigDecimal longitude) {
            this.longitude = longitude;
            return this;
        }

        @Override
        public Builder longitude(double longitude) {
            this.longitude = BigDecimal.valueOf(longitude);
            return this;
        }

        @Override
        public LatLonAware build() {
            return new LatLon(this.latitude, this.longitude);
        }
    }

    public static interface Builder {
        public Builder from(LatLonAware var1);

        public Builder latitude(BigDecimal var1);

        public Builder latitude(double var1);

        public Builder longitude(BigDecimal var1);

        public Builder longitude(double var1);

        public LatLonAware build();
    }
}

