/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.geojson.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.math.BigDecimal;
import lombok.Generated;
import org.bremersee.geojson.model.LatLonAware;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Point;

@Schema(description="WGS84 position with latitude and longitude.")
@JsonIgnoreProperties(ignoreUnknown=true)
public class LatitudeLongitude
implements LatLonAware,
Serializable {
    private static final long serialVersionUID = 1L;
    @Schema(description="The latitude.")
    private BigDecimal latitude;
    @Schema(description="The longitude.")
    private BigDecimal longitude;

    @JsonCreator
    public LatitudeLongitude(@JsonProperty(value="latitude") BigDecimal latitude, @JsonProperty(value="longitude") BigDecimal longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public LatitudeLongitude(LatLonAware latLonAware) {
        if (latLonAware != null) {
            this.latitude = latLonAware.getLatitude();
            this.longitude = latLonAware.getLongitude();
        }
    }

    public LatitudeLongitude(Point point) {
        if (point != null) {
            this.latitude = BigDecimal.valueOf(point.getY());
            this.longitude = BigDecimal.valueOf(point.getX());
        }
    }

    public LatitudeLongitude(Coordinate coordinate) {
        if (coordinate != null) {
            this.latitude = BigDecimal.valueOf(coordinate.getY());
            this.longitude = BigDecimal.valueOf(coordinate.getX());
        }
    }

    @Override
    @JsonProperty(value="latitude")
    public BigDecimal getLatitude() {
        return this.latitude;
    }

    @Override
    @JsonProperty(value="longitude")
    public BigDecimal getLongitude() {
        return this.longitude;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LatitudeLongitude)) {
            return false;
        }
        LatitudeLongitude other = (LatitudeLongitude)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigDecimal this$latitude = this.getLatitude();
        BigDecimal other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
            return false;
        }
        BigDecimal this$longitude = this.getLongitude();
        BigDecimal other$longitude = other.getLongitude();
        return !(this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LatitudeLongitude;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
        BigDecimal $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LatitudeLongitude(latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ")";
    }
}

