/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.geojson.utils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class ConvertHelper
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final int MAXIMUM_INTEGER_DIGITS = 17;
    private static final int MAXIMUM_FRACTION_DIGITS = 9;
    private static final String TYPE_ATTRIBUTE_NAME = "type";
    private static final String COORDINATES_ATTRIBUTE_NAME = "coordinates";
    private static final String GEOMETRIES_ATTRIBUTE_NAME = "geometries";
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance(Locale.US);
    private static final NumberFormat TEST_NUMBER_FORMAT = NumberFormat.getInstance(Locale.US);
    private final GeometryFactory geometryFactory;
    private final boolean useBigDecimal;

    public ConvertHelper() {
        this(null);
    }

    public ConvertHelper(GeometryFactory geometryFactory) {
        this(geometryFactory, true);
    }

    public ConvertHelper(GeometryFactory geometryFactory, boolean useBigDecimal) {
        this.geometryFactory = geometryFactory != null ? geometryFactory : new GeometryFactory();
        this.useBigDecimal = useBigDecimal;
    }

    public GeometryFactory getGeometryFactory() {
        return this.geometryFactory;
    }

    private double toPrimitiveDoubleValue(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument must be a Number.");
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return new BigDecimal(String.valueOf(value)).doubleValue();
    }

    private Coordinate createCoordinate(List<Object> coordinates) {
        Coordinate coordinate = new Coordinate();
        coordinate.x = !coordinates.isEmpty() ? this.toPrimitiveDoubleValue(coordinates.get(0)) : Double.NaN;
        coordinate.y = coordinates.size() > 1 ? this.toPrimitiveDoubleValue(coordinates.get(1)) : Double.NaN;
        return coordinate;
    }

    private Coordinate[] coordinatesToArray(List<Object> coordinates) {
        Coordinate[] coords = new Coordinate[coordinates.size()];
        int i = 0;
        for (Object obj : coordinates) {
            List list = (List)obj;
            coords[i] = this.createCoordinate(list);
            ++i;
        }
        return coords;
    }

    public Point createPoint(List<Object> coordinates) {
        return this.getGeometryFactory().createPoint(this.createCoordinate(coordinates));
    }

    public LineString createLineString(List<Object> coordinates) {
        return this.getGeometryFactory().createLineString(this.coordinatesToArray(coordinates));
    }

    public Polygon createPolygon(List<Object> coordinates) {
        ArrayList<Coordinate[]> list = new ArrayList<Coordinate[]>();
        for (Object obj : coordinates) {
            List coords = (List)obj;
            list.add(this.coordinatesToArray(coords));
        }
        if (list.size() == 1) {
            return this.getGeometryFactory().createPolygon((Coordinate[])list.get(0));
        }
        GeometryFactory gf = this.getGeometryFactory();
        LinearRing[] holes = new LinearRing[list.size() - 1];
        for (int i = 1; i < list.size(); ++i) {
            holes[i - 1] = gf.createLinearRing((Coordinate[])list.get(i));
        }
        return gf.createPolygon(gf.createLinearRing((Coordinate[])list.get(0)), holes);
    }

    public MultiPoint createMultiPoint(List<Object> coordinates) {
        Point[] points = new Point[coordinates.size()];
        int i = 0;
        for (Object obj : coordinates) {
            List list = (List)obj;
            points[i] = this.createPoint(list);
            ++i;
        }
        return this.getGeometryFactory().createMultiPoint(points);
    }

    public MultiLineString createMultiLineString(List<Object> coordinates) {
        LineString[] lineStrings = new LineString[coordinates.size()];
        int i = 0;
        for (Object obj : coordinates) {
            List list = (List)obj;
            lineStrings[i] = this.createLineString(list);
            ++i;
        }
        return this.getGeometryFactory().createMultiLineString(lineStrings);
    }

    public MultiPolygon createMultiPolygon(List<Object> coordinates) {
        Polygon[] polygons = new Polygon[coordinates.size()];
        int i = 0;
        for (Object obj : coordinates) {
            List list = (List)obj;
            polygons[i] = this.createPolygon(list);
            ++i;
        }
        return this.getGeometryFactory().createMultiPolygon(polygons);
    }

    public GeometryCollection createGeometryCollection(List<Geometry> geometries) {
        Geometry[] geoms = geometries == null ? new Geometry[]{} : geometries.toArray(new Geometry[0]);
        GeometryFactory gf = this.getGeometryFactory();
        return gf.createGeometryCollection(geoms);
    }

    public Map<String, Object> create(Geometry geometry) {
        if (geometry instanceof Point) {
            return this.pointToJsonMap((Point)geometry);
        }
        if (geometry instanceof LineString) {
            return this.lineToJsonMap((LineString)geometry);
        }
        if (geometry instanceof Polygon) {
            return this.polygonToJsonMap((Polygon)geometry);
        }
        if (geometry instanceof MultiPoint) {
            return this.multiPointToJsonMap((MultiPoint)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return this.multiLineToJsonMap((MultiLineString)geometry);
        }
        if (geometry instanceof MultiPolygon) {
            return this.multiPolygonToJsonMap((MultiPolygon)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return this.geometryCollectionToJsonMap((GeometryCollection)geometry);
        }
        throw new IllegalArgumentException("Geometry [" + geometry + "] is unsupported. It must be an instance of Point, LineString, Polygon, MultiPoint, MultiLineString, MultiPolygon or GeometryCollection.");
    }

    private Map<String, Object> pointToJsonMap(Point point) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(TYPE_ATTRIBUTE_NAME, "Point");
        map.put(COORDINATES_ATTRIBUTE_NAME, this.coordinateToList(point.getCoordinate()));
        return map;
    }

    private Map<String, Object> lineToJsonMap(LineString line) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(TYPE_ATTRIBUTE_NAME, "LineString");
        map.put(COORDINATES_ATTRIBUTE_NAME, this.coordinatesToList(line.getCoordinateSequence()));
        return map;
    }

    private Map<String, Object> polygonToJsonMap(Polygon polygon) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(TYPE_ATTRIBUTE_NAME, "Polygon");
        map.put(COORDINATES_ATTRIBUTE_NAME, this.polygonToList(polygon));
        return map;
    }

    private Map<String, Object> multiPointToJsonMap(MultiPoint multiPoint) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(TYPE_ATTRIBUTE_NAME, "MultiPoint");
        map.put(COORDINATES_ATTRIBUTE_NAME, this.geometryCollectionToList((GeometryCollection)multiPoint));
        return map;
    }

    private Map<String, Object> multiLineToJsonMap(MultiLineString multiLine) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(TYPE_ATTRIBUTE_NAME, "MultiLineString");
        map.put(COORDINATES_ATTRIBUTE_NAME, this.geometryCollectionToList((GeometryCollection)multiLine));
        return map;
    }

    private Map<String, Object> multiPolygonToJsonMap(MultiPolygon multiPolygon) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(TYPE_ATTRIBUTE_NAME, "MultiPolygon");
        map.put(COORDINATES_ATTRIBUTE_NAME, this.geometryCollectionToList((GeometryCollection)multiPolygon));
        return map;
    }

    private Map<String, Object> geometryCollectionToJsonMap(GeometryCollection geometryColllection) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        ArrayList<Map<String, Object>> geometries = new ArrayList<Map<String, Object>>(geometryColllection.getNumGeometries());
        for (int i = 0; i < geometryColllection.getNumGeometries(); ++i) {
            geometries.add(this.create(geometryColllection.getGeometryN(i)));
        }
        map.put(TYPE_ATTRIBUTE_NAME, "GeometryCollection");
        map.put(GEOMETRIES_ATTRIBUTE_NAME, geometries);
        return map;
    }

    private Number round(double value) {
        if (Double.isNaN(value)) {
            return null;
        }
        if (this.formatValue(value)) {
            String strValue = NUMBER_FORMAT.format(value);
            return this.useBigDecimal ? new BigDecimal(strValue) : Double.valueOf(new BigDecimal(strValue).doubleValue());
        }
        return this.useBigDecimal ? BigDecimal.valueOf(value) : Double.valueOf(value);
    }

    private boolean formatValue(double value) {
        String[] testValues = TEST_NUMBER_FORMAT.format(value).split(Pattern.quote("."));
        return testValues[0].length() > 17 || testValues.length > 1 && testValues[1].length() > 9;
    }

    private List<Object> coordinateToList(Coordinate coordinate) {
        if (coordinate == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>(2);
        double dx = coordinate.getX();
        list.add(this.round(dx));
        double dy = coordinate.getY();
        list.add(this.round(dy));
        return list;
    }

    private List<List<Object>> coordinatesToList(CoordinateSequence coordinateSequence) {
        if (coordinateSequence == null || coordinateSequence.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<List<Object>> list = new ArrayList<List<Object>>(coordinateSequence.size());
        for (int n = 0; n < coordinateSequence.size(); ++n) {
            list.add(this.coordinateToList(coordinateSequence.getCoordinate(n)));
        }
        return list;
    }

    private List<List<List<Object>>> polygonToList(Polygon polygon) {
        ArrayList<List<List<Object>>> list = new ArrayList<List<List<Object>>>();
        list.add(this.coordinatesToList(polygon.getExteriorRing().getCoordinateSequence()));
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            list.add(this.coordinatesToList(polygon.getInteriorRingN(i).getCoordinateSequence()));
        }
        return list;
    }

    private List<Object> geometryCollectionToList(GeometryCollection geometryCollection) {
        ArrayList<Object> list = new ArrayList<Object>(geometryCollection.getNumGeometries());
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            Geometry g = geometryCollection.getGeometryN(i);
            if (g instanceof Polygon) {
                list.add(this.polygonToList((Polygon)g));
                continue;
            }
            if (g instanceof LineString) {
                list.add(this.coordinatesToList(((LineString)g).getCoordinateSequence()));
                continue;
            }
            if (!(g instanceof Point)) continue;
            list.add(this.coordinateToList(g.getCoordinate()));
        }
        return list;
    }

    static {
        NUMBER_FORMAT.setMaximumFractionDigits(9);
        NUMBER_FORMAT.setMaximumIntegerDigits(17);
        NUMBER_FORMAT.setRoundingMode(RoundingMode.HALF_UP);
        NUMBER_FORMAT.setGroupingUsed(false);
        TEST_NUMBER_FORMAT.setMaximumFractionDigits(10);
        TEST_NUMBER_FORMAT.setMaximumIntegerDigits(18);
        TEST_NUMBER_FORMAT.setRoundingMode(RoundingMode.HALF_UP);
        TEST_NUMBER_FORMAT.setGroupingUsed(false);
    }
}

