/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.geojson.utils;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.bremersee.geojson.utils.MercatorToWgs84CoordinateFilter;
import org.bremersee.geojson.utils.SwapCoordinateFilter;
import org.bremersee.geojson.utils.Wgs84ToMercatorCoordinateFilter;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public abstract class GeometryUtils {
    public static final double EARTH_RADIUS_METERS = 6378137.0;
    public static final double MERCATOR_MAX_LAT = 85.05112878;
    public static final double MERCATOR_MIN_LAT = -85.05112878;
    public static final String DEFAULT_SPATIAL_AUTHORITY = "EPSG";
    public static final int WGS84_SPATIAL_REFERENCE_ID = 4326;
    public static final String WGS84_CRS = "EPSG:4326";
    public static final int MERCATOR_SPATIAL_REFERENCE_ID = 3857;
    public static final int MERCATOR_SPATIAL_REFERENCE_ID_ALT = 900913;
    public static final String MERCATOR_CRS = "EPSG:3857";
    public static final String MERCATOR_CRS_ALT = "EPSG:900913";
    private static final GeometryFactory DEFAULT_GEOMETRY_FACTORY = new GeometryFactory();

    private GeometryUtils() {
    }

    private static GeometryFactory geometryFactory(GeometryFactory geometryFactory) {
        return geometryFactory != null ? geometryFactory : DEFAULT_GEOMETRY_FACTORY;
    }

    public static boolean equals(Geometry g1, Geometry g2) {
        if (g1 == null && g2 == null) {
            return true;
        }
        if (g1 == null || g2 == null) {
            return false;
        }
        if (g1 == g2) {
            return true;
        }
        if (g1 instanceof GeometryCollection && g2 instanceof GeometryCollection) {
            return GeometryUtils.equals((GeometryCollection)g1, (GeometryCollection)g2);
        }
        return g1.equals(g2);
    }

    private static boolean equals(GeometryCollection gc1, GeometryCollection gc2) {
        if (gc1.getNumGeometries() != gc2.getNumGeometries()) {
            return false;
        }
        for (int i = 0; i < gc1.getNumGeometries(); ++i) {
            Geometry g2;
            Geometry g1 = gc1.getGeometryN(i);
            if (GeometryUtils.equals(g1, g2 = gc2.getGeometryN(i))) continue;
            return false;
        }
        return true;
    }

    public static double[] getBoundingBox(Geometry geometry) {
        return Optional.ofNullable(geometry).map(g -> GeometryUtils.getBoundingBox(Collections.singletonList(g))).orElse(null);
    }

    public static double[] getBoundingBox(Collection<? extends Geometry> geometries) {
        if (geometries == null || geometries.isEmpty()) {
            return null;
        }
        double minX = Double.NaN;
        double minY = Double.NaN;
        double minZ = Double.NaN;
        double maxX = Double.NaN;
        double maxY = Double.NaN;
        double maxZ = Double.NaN;
        for (Geometry geometry : geometries) {
            if (geometry == null || geometry.getCoordinates() == null) continue;
            Coordinate[] coords = geometry.getCoordinates();
            for (int i = 0; i < coords.length; ++i) {
                if (Double.isNaN(minX)) {
                    minX = coords[i].getX();
                } else if (!Double.isNaN(coords[i].getX())) {
                    minX = Math.min(minX, coords[i].getX());
                }
                if (Double.isNaN(minY)) {
                    minY = coords[i].getY();
                } else if (!Double.isNaN(coords[i].getY())) {
                    minY = Math.min(minY, coords[i].getY());
                }
                if (Double.isNaN(minZ)) {
                    minZ = coords[i].getZ();
                } else if (!Double.isNaN(coords[i].getZ())) {
                    minZ = Math.min(minZ, coords[i].getZ());
                }
                if (Double.isNaN(maxX)) {
                    maxX = coords[i].getX();
                } else if (!Double.isNaN(coords[i].getX())) {
                    maxX = Math.max(maxX, coords[i].getX());
                }
                if (Double.isNaN(maxY)) {
                    maxY = coords[i].getY();
                } else if (!Double.isNaN(coords[i].getY())) {
                    maxY = Math.max(maxY, coords[i].getY());
                }
                if (Double.isNaN(maxZ)) {
                    maxZ = coords[i].getZ();
                    continue;
                }
                if (Double.isNaN(coords[i].getZ())) continue;
                maxZ = Math.max(maxZ, coords[i].getZ());
            }
        }
        if (!(Double.isNaN(minX) || Double.isNaN(maxX) || Double.isNaN(minY) || Double.isNaN(maxY))) {
            if (!Double.isNaN(minZ) && !Double.isNaN(maxZ)) {
                return new double[]{minX, minY, minZ, maxX, maxY, maxZ};
            }
            return new double[]{minX, minY, maxX, maxY};
        }
        return null;
    }

    public static Coordinate getSouthWest(double[] boundingBox) {
        if (boundingBox == null || boundingBox.length != 4 && boundingBox.length != 6) {
            return null;
        }
        return GeometryUtils.createCoordinate(boundingBox[0], boundingBox[1]);
    }

    public static Coordinate getNorthWest(double[] boundingBox) {
        if (boundingBox == null || boundingBox.length != 4 && boundingBox.length != 6) {
            return null;
        }
        if (boundingBox.length == 6) {
            return GeometryUtils.createCoordinate(boundingBox[0], boundingBox[4]);
        }
        return GeometryUtils.createCoordinate(boundingBox[0], boundingBox[3]);
    }

    public static Coordinate getNorthEast(double[] boundingBox) {
        if (boundingBox == null || boundingBox.length != 4 && boundingBox.length != 6) {
            return null;
        }
        if (boundingBox.length == 6) {
            return GeometryUtils.createCoordinate(boundingBox[3], boundingBox[4]);
        }
        return GeometryUtils.createCoordinate(boundingBox[2], boundingBox[3]);
    }

    public static Coordinate getSouthEast(double[] boundingBox) {
        if (boundingBox == null || boundingBox.length != 4 && boundingBox.length != 6) {
            return null;
        }
        if (boundingBox.length == 6) {
            return GeometryUtils.createCoordinate(boundingBox[3], boundingBox[1]);
        }
        return GeometryUtils.createCoordinate(boundingBox[2], boundingBox[1]);
    }

    public static Polygon getBoundingBoxAsPolygon2D(double[] boundingBox) {
        return GeometryUtils.getBoundingBoxAsPolygon2D(boundingBox, null);
    }

    public static Polygon getBoundingBoxAsPolygon2D(double[] boundingBox, GeometryFactory geometryFactory) {
        float y2;
        float x2;
        Coordinate sw = GeometryUtils.getSouthWest(boundingBox);
        Coordinate se = GeometryUtils.getSouthEast(boundingBox);
        Coordinate ne = GeometryUtils.getNorthEast(boundingBox);
        Coordinate nw = GeometryUtils.getNorthWest(boundingBox);
        if (sw == null || se == null || ne == null || nw == null) {
            return null;
        }
        float x1 = (float)sw.getX();
        if (x1 == (x2 = (float)se.getX())) {
            return null;
        }
        float y1 = (float)sw.getY();
        if (y1 == (y2 = (float)nw.getY())) {
            return null;
        }
        return GeometryUtils.createPolygon(GeometryUtils.createLinearRing(Arrays.asList(sw, se, ne, nw, sw), geometryFactory), geometryFactory);
    }

    public static Polygon getBoundingBoxAsPolygon2D(Geometry geometry) {
        return GeometryUtils.getBoundingBoxAsPolygon2D(geometry, null);
    }

    public static Polygon getBoundingBoxAsPolygon2D(Geometry geometry, GeometryFactory geometryFactory) {
        return GeometryUtils.getBoundingBoxAsPolygon2D(GeometryUtils.getBoundingBox(geometry), geometryFactory);
    }

    public static String toWKT(Geometry geometry) {
        return Optional.ofNullable(geometry).map(Geometry::toText).orElse(null);
    }

    public static Geometry fromWKT(String wkt) throws IllegalArgumentException {
        return GeometryUtils.fromWKT(wkt, null);
    }

    public static Geometry fromWKT(String wkt, GeometryFactory geometryFactory) throws IllegalArgumentException {
        try {
            return new WKTReader(GeometryUtils.geometryFactory(geometryFactory)).read(wkt);
        }
        catch (NullPointerException n) {
            return null;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Parsing WKT [" + wkt + "] failed.", e);
        }
    }

    public static Geometry fromWKT(Reader reader) throws IllegalArgumentException {
        return GeometryUtils.fromWKT(reader, null);
    }

    public static Geometry fromWKT(Reader reader, GeometryFactory geometryFactory) throws IllegalArgumentException {
        Geometry geometry;
        block9: {
            Reader r = reader;
            try {
                geometry = new WKTReader(GeometryUtils.geometryFactory(geometryFactory)).read(r);
                if (r == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NullPointerException n) {
                    return null;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
            r.close();
        }
        return geometry;
    }

    public static Geometry fromWKT(InputStream inputStream, String charsetName) throws IllegalArgumentException {
        return GeometryUtils.fromWKT(inputStream, charsetName, null);
    }

    public static Geometry fromWKT(InputStream inputStream, String charsetName, GeometryFactory geometryFactory) throws IllegalArgumentException {
        Geometry geometry;
        String cs = charsetName == null ? StandardCharsets.UTF_8.name() : charsetName;
        InputStreamReader reader = new InputStreamReader(inputStream, cs);
        try {
            geometry = GeometryUtils.fromWKT(reader, geometryFactory);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (NullPointerException n) {
                return null;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        reader.close();
        return geometry;
    }

    public static Coordinate createCoordinate(double x, double y) {
        return new Coordinate(x, y);
    }

    public static Coordinate createCoordinate(BigDecimal x, BigDecimal y) {
        return Optional.ofNullable(x).map(xx -> Optional.ofNullable(y).map(yy -> new Coordinate(xx.doubleValue(), yy.doubleValue())).orElseThrow(() -> new IllegalArgumentException("Y must not be null."))).orElseThrow(() -> new IllegalArgumentException("X must not be null."));
    }

    public static Coordinate createCoordinateWGS84(double latitude, double longitude) {
        return new Coordinate(longitude, latitude);
    }

    public static Coordinate createCoordinateWGS84(BigDecimal latitude, BigDecimal longitude) {
        return Optional.ofNullable(latitude).map(lat -> Optional.ofNullable(longitude).map(lon -> new Coordinate(lon.doubleValue(), lat.doubleValue())).orElseThrow(() -> new IllegalArgumentException("Longitude must not be null."))).orElseThrow(() -> new IllegalArgumentException("Latitude must not be null."));
    }

    public static double getLatitudeWGS84(Coordinate coordinate) {
        return Optional.ofNullable(coordinate).map(Coordinate::getY).orElseThrow(() -> new IllegalArgumentException("Coordinate must not be null."));
    }

    public static double getLongitudeWGS84(Coordinate coordinate) {
        return Optional.ofNullable(coordinate).map(Coordinate::getX).orElseThrow(() -> new IllegalArgumentException("Coordinate must not be null."));
    }

    public static Point createPoint(double x, double y) {
        return GeometryUtils.createPoint(GeometryUtils.createCoordinate(x, y), null);
    }

    public static Point createPoint(double x, double y, GeometryFactory geometryFactory) {
        return GeometryUtils.createPoint(GeometryUtils.createCoordinate(x, y), geometryFactory);
    }

    public static Point createPoint(BigDecimal x, BigDecimal y) {
        return GeometryUtils.createPoint(GeometryUtils.createCoordinate(x, y), null);
    }

    public static Point createPoint(BigDecimal x, BigDecimal y, GeometryFactory geometryFactory) {
        return GeometryUtils.createPoint(GeometryUtils.createCoordinate(x, y), geometryFactory);
    }

    public static Point createPoint(Coordinate coordinate) {
        return GeometryUtils.createPoint(coordinate, null);
    }

    public static Point createPoint(Coordinate coordinate, GeometryFactory geometryFactory) {
        return GeometryUtils.geometryFactory(geometryFactory).createPoint(coordinate);
    }

    public static Point createPointWGS84(double latitude, double longitude) {
        return GeometryUtils.createPoint(longitude, latitude, null);
    }

    public static Point createPointWGS84(BigDecimal latitude, BigDecimal longitude) {
        return GeometryUtils.createPoint(longitude, latitude, null);
    }

    public static Point createPointWGS84(double latitude, double longitude, GeometryFactory geometryFactory) {
        return GeometryUtils.createPoint(longitude, latitude, geometryFactory);
    }

    public static Point createPointWGS84(BigDecimal latitude, BigDecimal longitude, GeometryFactory geometryFactory) {
        return GeometryUtils.createPoint(longitude, latitude, geometryFactory);
    }

    public static MultiPoint createMultiPoint(Collection<? extends Point> points) {
        return GeometryUtils.createMultiPoint(points, null);
    }

    public static MultiPoint createMultiPoint(Collection<? extends Point> points, GeometryFactory geometryFactory) {
        return Optional.ofNullable(points).map(c -> c.toArray(new Point[0])).map(a -> GeometryUtils.geometryFactory(geometryFactory).createMultiPoint(a)).orElseGet(() -> GeometryUtils.geometryFactory(geometryFactory).createMultiPoint());
    }

    public static LineString createLineString(Collection<? extends Coordinate> coordinates) {
        return GeometryUtils.createLineString(coordinates, null);
    }

    public static LineString createLineString(Collection<? extends Coordinate> coordinates, GeometryFactory geometryFactory) {
        return Optional.ofNullable(coordinates).map(c -> c.toArray(new Coordinate[0])).map(a -> GeometryUtils.geometryFactory(geometryFactory).createLineString(a)).orElseGet(() -> GeometryUtils.geometryFactory(geometryFactory).createLineString());
    }

    public static MultiLineString createMultiLineString(Collection<? extends LineString> lineStrings) {
        return GeometryUtils.createMultiLineString(lineStrings, null);
    }

    public static MultiLineString createMultiLineString(Collection<? extends LineString> lineStrings, GeometryFactory geometryFactory) {
        return Optional.ofNullable(lineStrings).map(c -> c.toArray(new LineString[0])).map(a -> GeometryUtils.geometryFactory(geometryFactory).createMultiLineString(a)).orElseGet(() -> GeometryUtils.geometryFactory(geometryFactory).createMultiLineString());
    }

    public static LinearRing createLinearRing(Collection<? extends Coordinate> coordinates) {
        return GeometryUtils.createLinearRing(coordinates, null);
    }

    public static LinearRing createLinearRing(Collection<? extends Coordinate> coordinates, GeometryFactory geometryFactory) {
        return Optional.ofNullable(coordinates).map(c -> c.toArray(new Coordinate[0])).map(a -> GeometryUtils.geometryFactory(geometryFactory).createLinearRing(a)).orElseGet(() -> GeometryUtils.geometryFactory(geometryFactory).createLinearRing());
    }

    public static Polygon createPolygon(LinearRing shell) {
        return GeometryUtils.createPolygon(shell, null, null);
    }

    public static Polygon createPolygon(LinearRing shell, GeometryFactory geometryFactory) {
        return GeometryUtils.createPolygon(shell, null, geometryFactory);
    }

    public static Polygon createPolygon(LinearRing shell, Collection<? extends LinearRing> holes) {
        return GeometryUtils.createPolygon(shell, holes, null);
    }

    public static Polygon createPolygon(LinearRing shell, Collection<? extends LinearRing> holes, GeometryFactory geometryFactory) {
        return Optional.ofNullable(shell).map(s -> Optional.ofNullable(holes).map(c -> c.toArray(new LinearRing[0])).map(a -> GeometryUtils.geometryFactory(geometryFactory).createPolygon(s, a)).orElseGet(() -> GeometryUtils.geometryFactory(geometryFactory).createPolygon(s))).orElseGet(() -> GeometryUtils.geometryFactory(geometryFactory).createPolygon());
    }

    public static MultiPolygon createMultiPolygon(Collection<? extends Polygon> polygons) {
        return GeometryUtils.createMultiPolygon(polygons, null);
    }

    public static MultiPolygon createMultiPolygon(Collection<? extends Polygon> polygons, GeometryFactory geometryFactory) {
        return Optional.ofNullable(polygons).map(c -> c.toArray(new Polygon[0])).map(a -> GeometryUtils.geometryFactory(geometryFactory).createMultiPolygon(a)).orElseGet(() -> GeometryUtils.geometryFactory(geometryFactory).createMultiPolygon());
    }

    public static GeometryCollection createGeometryCollection(Geometry ... geometries) {
        return Optional.ofNullable(geometries).map(arg_0 -> ((GeometryFactory)DEFAULT_GEOMETRY_FACTORY).createGeometryCollection(arg_0)).orElseGet(() -> ((GeometryFactory)DEFAULT_GEOMETRY_FACTORY).createGeometryCollection());
    }

    public static GeometryCollection createGeometryCollection(Collection<? extends Geometry> geometries) {
        return GeometryUtils.createGeometryCollection(geometries, DEFAULT_GEOMETRY_FACTORY);
    }

    public static GeometryCollection createGeometryCollection(Collection<? extends Geometry> geometries, GeometryFactory geometryFactory) {
        return Optional.ofNullable(geometries).map(g -> g.toArray(new Geometry[0])).map(a -> GeometryUtils.geometryFactory(geometryFactory).createGeometryCollection(a)).orElseGet(() -> GeometryUtils.geometryFactory(geometryFactory).createGeometryCollection());
    }

    public static Geometry copyAndApplyFilters(Geometry geometry, CoordinateFilter ... filters) {
        return Optional.ofNullable(geometry).map(g -> {
            Geometry result = g.copy();
            if (filters != null) {
                for (CoordinateFilter filter : filters) {
                    result.apply(filter);
                }
            }
            return result;
        }).orElse(null);
    }

    public static Geometry transformWgs84ToMercator(Geometry geometry) {
        return GeometryUtils.copyAndApplyFilters(geometry, new Wgs84ToMercatorCoordinateFilter());
    }

    public static Geometry transformMercatorToWgs84(Geometry geometry) {
        return GeometryUtils.copyAndApplyFilters(geometry, new MercatorToWgs84CoordinateFilter());
    }

    public static Geometry swapCoordinates(Geometry geometry) {
        return GeometryUtils.copyAndApplyFilters(geometry, new SwapCoordinateFilter());
    }
}

