/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.geojson.utils;

import java.util.Objects;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;

public class MercatorToWgs84CoordinateFilter
implements CoordinateFilter {
    private double earthRadiusInMeters = 6378137.0;

    public MercatorToWgs84CoordinateFilter() {
    }

    public MercatorToWgs84CoordinateFilter(double earthRadiusInMeters) {
        this.earthRadiusInMeters = earthRadiusInMeters;
    }

    public double getEarthRadiusInMeters() {
        return this.earthRadiusInMeters;
    }

    public void setEarthRadiusInMeters(double earthRadiusInMeters) {
        this.earthRadiusInMeters = earthRadiusInMeters;
    }

    public void filter(Coordinate coord) {
        if (coord != null) {
            if (!Double.isNaN(coord.x)) {
                coord.x = coord.x * 180.0 / (this.getEarthRadiusInMeters() * Math.PI);
            }
            if (!Double.isNaN(coord.y)) {
                coord.y = Math.toDegrees(2.0 * Math.atan(Math.exp(coord.y / this.getEarthRadiusInMeters())) - 1.5707963267948966);
            }
        }
    }

    public String toString() {
        return "MercatorToWgs84CoordinateFilter{earthRadiusInMeters=" + this.earthRadiusInMeters + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MercatorToWgs84CoordinateFilter that = (MercatorToWgs84CoordinateFilter)o;
        return Double.compare(that.earthRadiusInMeters, this.earthRadiusInMeters) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.earthRadiusInMeters);
    }
}

