/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.geojson.utils;

import java.io.Serializable;
import java.util.Objects;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;

public class Wgs84ToMercatorCoordinateFilter
implements CoordinateFilter,
Serializable {
    private static final long serialVersionUID = 2L;
    private double earthRadiusInMeters = 6378137.0;

    public Wgs84ToMercatorCoordinateFilter() {
    }

    public Wgs84ToMercatorCoordinateFilter(double earthRadiusInMeters) {
        this.earthRadiusInMeters = earthRadiusInMeters;
    }

    public double getEarthRadiusInMeters() {
        return this.earthRadiusInMeters;
    }

    public void setEarthRadiusInMeters(double earthRadiusInMeters) {
        this.earthRadiusInMeters = earthRadiusInMeters;
    }

    public void filter(Coordinate coord) {
        if (coord != null) {
            if (!Double.isNaN(coord.x)) {
                coord.x = coord.x * this.getEarthRadiusInMeters() * Math.PI / 180.0;
            }
            if (!Double.isNaN(coord.y)) {
                if (coord.y > 85.05112878) {
                    coord.y = 85.05112878;
                } else if (coord.y < -85.05112878) {
                    coord.y = -85.05112878;
                }
                coord.y = Math.log(Math.tan(0.7853981633974483 + Math.toRadians(coord.y) / 2.0)) * this.getEarthRadiusInMeters();
            }
        }
    }

    public String toString() {
        return "Wgs84ToMercatorCoordinateFilter{earthRadiusInMeters=" + this.earthRadiusInMeters + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Wgs84ToMercatorCoordinateFilter that = (Wgs84ToMercatorCoordinateFilter)o;
        return Double.compare(that.earthRadiusInMeters, this.earthRadiusInMeters) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.earthRadiusInMeters);
    }
}

