/*
 * Decompiled with CFR 0.152.
 */
package org.briarproject.android.dontkillmelib.wakelock;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.briarproject.android.dontkillmelib.wakelock.AndroidWakeLock;
import org.briarproject.android.dontkillmelib.wakelock.SharedWakeLock;
import org.briarproject.nullsafety.NotNullByDefault;

@NotNullByDefault
@ThreadSafe
class AndroidWakeLockImpl
implements AndroidWakeLock {
    private static final Logger LOG = Logger.getLogger(AndroidWakeLockImpl.class.getName());
    private static final AtomicInteger INSTANCE_ID = new AtomicInteger(0);
    private final SharedWakeLock sharedWakeLock;
    private final String tag;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private boolean held = false;

    AndroidWakeLockImpl(SharedWakeLock sharedWakeLock, String tag) {
        this.sharedWakeLock = sharedWakeLock;
        this.tag = tag + "_" + INSTANCE_ID.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquire() {
        Object object = this.lock;
        synchronized (object) {
            if (this.held) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(this.tag + " already acquired");
                }
            } else {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(this.tag + " acquiring shared wake lock");
                }
                this.held = true;
                this.sharedWakeLock.acquire();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.lock;
        synchronized (object) {
            if (this.held) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(this.tag + " releasing shared wake lock");
                }
                this.held = false;
                this.sharedWakeLock.release();
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this.tag + " already released");
            }
        }
    }
}

