/*
 * Decompiled with CFR 0.152.
 */
package org.briarproject.android.dontkillmelib.wakelock;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.PowerManager;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.briarproject.android.dontkillmelib.wakelock.AndroidWakeLock;
import org.briarproject.android.dontkillmelib.wakelock.AndroidWakeLockImpl;
import org.briarproject.android.dontkillmelib.wakelock.AndroidWakeLockManager;
import org.briarproject.android.dontkillmelib.wakelock.RenewableWakeLock;
import org.briarproject.android.dontkillmelib.wakelock.SharedWakeLock;
import org.briarproject.nullsafety.NotNullByDefault;
import org.briarproject.nullsafety.NullSafety;

@NotNullByDefault
class AndroidWakeLockManagerImpl
implements AndroidWakeLockManager {
    private static final long LOCK_DURATION_MS = TimeUnit.MINUTES.toMillis(1L);
    private static final long SAFETY_MARGIN_MS = TimeUnit.SECONDS.toMillis(30L);
    private final SharedWakeLock sharedWakeLock;

    @Inject
    AndroidWakeLockManagerImpl(Application app, ScheduledExecutorService scheduledExecutorService) {
        PowerManager powerManager = (PowerManager)NullSafety.requireNonNull((Object)app.getSystemService("power"));
        String tag = this.getWakeLockTag((Context)app);
        this.sharedWakeLock = new RenewableWakeLock(powerManager, scheduledExecutorService, 1, tag, LOCK_DURATION_MS, SAFETY_MARGIN_MS);
    }

    @Override
    public AndroidWakeLock createWakeLock(String tag) {
        return new AndroidWakeLockImpl(this.sharedWakeLock, tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runWakefully(Runnable r, String tag) {
        AndroidWakeLock wakeLock = this.createWakeLock(tag);
        wakeLock.acquire();
        try {
            r.run();
        }
        finally {
            wakeLock.release();
        }
    }

    @Override
    public void executeWakefully(Runnable r, Executor executor, String tag) {
        AndroidWakeLock wakeLock = this.createWakeLock(tag);
        wakeLock.acquire();
        try {
            executor.execute(() -> {
                try {
                    r.run();
                }
                finally {
                    wakeLock.release();
                }
            });
        }
        catch (Exception e) {
            wakeLock.release();
            throw e;
        }
    }

    @Override
    public void executeWakefully(Runnable r, String tag) {
        AndroidWakeLock wakeLock = this.createWakeLock(tag);
        wakeLock.acquire();
        try {
            new Thread(() -> {
                try {
                    r.run();
                }
                finally {
                    wakeLock.release();
                }
            }).start();
        }
        catch (Exception e) {
            wakeLock.release();
            throw e;
        }
    }

    private String getWakeLockTag(Context ctx) {
        PackageManager pm = ctx.getPackageManager();
        if (this.isInstalled(pm, "com.huawei.powergenie")) {
            return "LocationManagerService";
        }
        if (this.isInstalled(pm, "com.evenwell.PowerMonitor")) {
            return "AudioIn";
        }
        return ctx.getPackageName();
    }

    private boolean isInstalled(PackageManager pm, String packageName) {
        try {
            pm.getPackageInfo(packageName, 0);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }
}

