/*
 * Decompiled with CFR 0.152.
 */
package org.briarproject.android.dontkillmelib.wakelock;

import android.os.PowerManager;
import android.os.SystemClock;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.briarproject.android.dontkillmelib.wakelock.SharedWakeLock;
import org.briarproject.nullsafety.NotNullByDefault;
import org.briarproject.nullsafety.NullSafety;

@NotNullByDefault
@ThreadSafe
class RenewableWakeLock
implements SharedWakeLock {
    private static final Logger LOG = Logger.getLogger(RenewableWakeLock.class.getName());
    private final PowerManager powerManager;
    private final ScheduledExecutorService scheduledExecutorService;
    private final int levelAndFlags;
    private final String tag;
    private final long durationMs;
    private final long safetyMarginMs;
    private final Object lock = new Object();
    @Nullable
    @GuardedBy(value="lock")
    private PowerManager.WakeLock wakeLock;
    @Nullable
    @GuardedBy(value="lock")
    private Future<?> future;
    @GuardedBy(value="lock")
    private int refCount = 0;
    @GuardedBy(value="lock")
    private long acquired = 0L;

    RenewableWakeLock(PowerManager powerManager, ScheduledExecutorService scheduledExecutorService, int levelAndFlags, String tag, long durationMs, long safetyMarginMs) {
        this.powerManager = powerManager;
        this.scheduledExecutorService = scheduledExecutorService;
        this.levelAndFlags = levelAndFlags;
        this.tag = tag;
        this.durationMs = durationMs;
        this.safetyMarginMs = safetyMarginMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquire() {
        Object object = this.lock;
        synchronized (object) {
            ++this.refCount;
            if (this.refCount == 1) {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("Acquiring wake lock " + this.tag);
                }
                this.wakeLock = this.powerManager.newWakeLock(this.levelAndFlags, this.tag);
                this.wakeLock.setReferenceCounted(false);
                this.wakeLock.acquire(this.durationMs + this.safetyMarginMs);
                this.future = this.scheduledExecutorService.schedule(this::renew, this.durationMs, TimeUnit.MILLISECONDS);
                this.acquired = SystemClock.elapsedRealtime();
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Wake lock " + this.tag + " has " + this.refCount + " holders");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renew() {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Renewing wake lock " + this.tag);
        }
        Object object = this.lock;
        synchronized (object) {
            long expiry;
            long now;
            if (this.wakeLock == null) {
                LOG.info("Already released");
                return;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Wake lock " + this.tag + " has " + this.refCount + " holders");
            }
            if ((now = SystemClock.elapsedRealtime()) > (expiry = this.acquired + this.durationMs + this.safetyMarginMs) && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Wake lock expired " + (now - expiry) + " ms ago");
            }
            PowerManager.WakeLock oldWakeLock = this.wakeLock;
            this.wakeLock = this.powerManager.newWakeLock(this.levelAndFlags, this.tag);
            this.wakeLock.setReferenceCounted(false);
            this.wakeLock.acquire(this.durationMs + this.safetyMarginMs);
            oldWakeLock.release();
            this.future = this.scheduledExecutorService.schedule(this::renew, this.durationMs, TimeUnit.MILLISECONDS);
            this.acquired = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.lock;
        synchronized (object) {
            --this.refCount;
            if (this.refCount == 0) {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("Releasing wake lock " + this.tag);
                }
                ((Future)NullSafety.requireNonNull(this.future)).cancel(false);
                this.future = null;
                ((PowerManager.WakeLock)NullSafety.requireNonNull((Object)this.wakeLock)).release();
                this.wakeLock = null;
                this.acquired = 0L;
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Wake lock " + this.tag + " has " + this.refCount + " holders");
            }
        }
    }
}

