/*
 * Decompiled with CFR 0.152.
 */
package net.freehaven.tor.control.examples;

import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.freehaven.tor.control.ConfigEntry;
import net.freehaven.tor.control.PasswordDigest;
import net.freehaven.tor.control.TorControlCommands;
import net.freehaven.tor.control.TorControlConnection;
import net.freehaven.tor.control.TorControlException;
import net.freehaven.tor.control.examples.DebuggingEventHandler;

public class Main
implements TorControlCommands {
    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("No command given.");
            return;
        }
        try {
            if (stringArray[0].equals("set-config")) {
                Main.setConfig(stringArray);
            } else if (stringArray[0].equals("get-config")) {
                Main.getConfig(stringArray);
            } else if (stringArray[0].equals("get-info")) {
                Main.getInfo(stringArray);
            } else if (stringArray[0].equals("listen")) {
                Main.listenForEvents(stringArray);
            } else if (stringArray[0].equals("signal")) {
                Main.signal(stringArray);
            } else if (stringArray[0].equals("auth")) {
                Main.authDemo(stringArray);
            } else {
                System.err.println("Unrecognized command: " + stringArray[0]);
            }
        }
        catch (EOFException eOFException) {
            System.out.println("Control socket closed by Tor.");
        }
        catch (TorControlException torControlException) {
            System.err.println("Error from Tor process: " + torControlException + " [" + torControlException.getErrorMsg() + "]");
        }
        catch (IOException iOException) {
            System.err.println("IO exception when talking to Tor process: " + iOException);
            iOException.printStackTrace(System.err);
        }
    }

    private static TorControlConnection getConnection(String[] stringArray, boolean bl) throws IOException {
        Socket socket = new Socket("127.0.0.1", 9100);
        TorControlConnection torControlConnection = new TorControlConnection(socket);
        torControlConnection.launchThread(bl);
        torControlConnection.authenticate(new byte[0]);
        return torControlConnection;
    }

    private static TorControlConnection getConnection(String[] stringArray) throws IOException {
        return Main.getConnection(stringArray, true);
    }

    public static void setConfig(String[] stringArray) throws IOException {
        TorControlConnection torControlConnection = Main.getConnection(stringArray);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 1;
        boolean bl = false;
        if (stringArray[n].equals("-save")) {
            bl = true;
            ++n;
        }
        while (n < stringArray.length) {
            arrayList.add(stringArray[n] + " " + stringArray[n + 1]);
            n += 2;
        }
        torControlConnection.setConf(arrayList);
        if (bl) {
            torControlConnection.saveConf();
        }
    }

    public static void getConfig(String[] stringArray) throws IOException {
        TorControlConnection torControlConnection = Main.getConnection(stringArray);
        List<ConfigEntry> list = torControlConnection.getConf(Arrays.asList(stringArray).subList(1, stringArray.length));
        for (ConfigEntry configEntry : list) {
            System.out.println("KEY: " + configEntry.key);
            System.out.println("VAL: " + configEntry.value);
        }
    }

    public static void getInfo(String[] stringArray) throws IOException {
        TorControlConnection torControlConnection = Main.getConnection(stringArray);
        Map<String, String> map = torControlConnection.getInfo(Arrays.asList(stringArray).subList(1, stringArray.length));
        for (Map.Entry<String, String> entry : map.entrySet()) {
            System.out.println("KEY: " + entry.getKey());
            System.out.println("VAL: " + entry.getValue());
        }
    }

    public static void listenForEvents(String[] stringArray) throws IOException {
        TorControlConnection torControlConnection = Main.getConnection(stringArray, false);
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray).subList(1, stringArray.length));
        torControlConnection.setEventHandler(new DebuggingEventHandler(new PrintWriter(System.out, true)));
        torControlConnection.setEvents(arrayList);
    }

    public static void signal(String[] stringArray) throws IOException {
        TorControlConnection torControlConnection = Main.getConnection(stringArray, false);
        if ("SHUTDOWN".equalsIgnoreCase(stringArray[1]) || "HALT".equalsIgnoreCase(stringArray[1])) {
            torControlConnection.shutdownTor(stringArray[1].toUpperCase());
        } else {
            torControlConnection.signal(stringArray[1].toUpperCase());
        }
    }

    public static void authDemo(String[] stringArray) throws IOException {
        PasswordDigest passwordDigest = PasswordDigest.generateDigest();
        Socket socket = new Socket("127.0.0.1", 9100);
        TorControlConnection torControlConnection = new TorControlConnection(socket);
        torControlConnection.launchThread(true);
        torControlConnection.authenticate(new byte[0]);
        torControlConnection.setConf("HashedControlPassword", passwordDigest.getHashedPassword());
        socket = new Socket("127.0.0.1", 9100);
        torControlConnection = new TorControlConnection(socket);
        torControlConnection.launchThread(true);
        torControlConnection.authenticate(passwordDigest.getSecret());
    }
}

