/*
 * Decompiled with CFR 0.152.
 */
package org.briarproject.onionwrapper;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import org.briarproject.nullsafety.NotNullByDefault;
import org.briarproject.onionwrapper.UnixTorWrapper;

@NotNullByDefault
public class MacTorWrapper
extends UnixTorWrapper {
    static final String LIB_EVENT_VERSION = "2.1.7";

    public MacTorWrapper(Executor ioExecutor, Executor eventExecutor, String architecture, File torDirectory, int torSocksPort, int torControlPort) {
        super(ioExecutor, eventExecutor, architecture, torDirectory, torSocksPort, torControlPort);
    }

    protected void installTorExecutable() throws IOException {
        super.installTorExecutable();
        this.installLibEvent();
    }

    private void installLibEvent() throws IOException {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Installing libevent binary for " + this.architecture);
        }
        File libEventFile = this.getLibEventFile();
        this.extract(this.getExecutableInputStream("libevent-2.1.7.dylib"), libEventFile);
    }

    private File getLibEventFile() {
        return new File(this.torDirectory, "libevent-2.1.7.dylib");
    }

    protected void extract(InputStream in, File dest) throws IOException {
        dest.delete();
        super.extract(in, dest);
    }
}

