/*
 * Decompiled with CFR 0.152.
 */
package org.briarproject.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.briarproject.nullsafety.NotNullByDefault;

@NotNullByDefault
public class IoUtils {
    public static void readFully(InputStream in, byte[] b) throws IOException {
        int read;
        for (int offset = 0; offset < b.length; offset += read) {
            read = in.read(b, offset, b.length - offset);
            if (read != -1) continue;
            throw new EOFException();
        }
    }

    public static InputStream getInputStream(Socket s) throws IOException {
        try {
            return s.getInputStream();
        }
        catch (NullPointerException e) {
            throw new IOException(e);
        }
    }

    public static OutputStream getOutputStream(Socket s) throws IOException {
        try {
            return s.getOutputStream();
        }
        catch (NullPointerException e) {
            throw new IOException(e);
        }
    }
}

