package org.brickred.socialauth.util;

/**
 * OAuth constants
 * 
 */

public interface Constants {

	/**
	 * UTF-8
	 */
	public static final String ENCODING = "UTF-8";

	/**
	 * oauth_consumer_key
	 */
	public static final String OAUTH_CONSUMER_KEY = "oauth_consumer_key";

	/**
	 * oauth_signature_method
	 */
	public static final String OAUTH_SIGNATURE_METHOD = "oauth_signature_method";

	/**
	 * oauth_signature
	 */
	public static final String OAUTH_SIGNATURE = "oauth_signature";

	/**
	 * "oauth_timestamp"
	 */
	public static final String OAUTH_TIMESTAMP = "oauth_timestamp";

	/**
	 * "oauth_nonce"
	 */
	public static final String OAUTH_NONCE = "oauth_nonce";

	/**
	 * "oauth_version"
	 */
	public static final String OAUTH_VERSION = "oauth_version";

	/**
	 * "oauth_token"
	 */
	public static final String OAUTH_TOKEN = "oauth_token";

	/**
	 * "oauth_token_secret"
	 */
	public static final String OAUTH_TOKEN_SECRET = "oauth_token_secret";

	/**
	 * "oauth_callback"
	 */
	public static final String OAUTH_CALLBACK = "oauth_callback";

	/**
	 * "oauth_callback_confirmed"
	 */
	public static final String OAUTH_CALLBACK_CONFIRMED = "oauth_callback_confirmed";

	/**
	 * "oauth_problem"
	 */
	public static final String OAUTH_PROBLEM = "oauth_problem";

	/**
	 * "oauth_verifier"
	 */
	public static final String OAUTH_VERIFIER = "oauth_verifier";

	/**
	 * "oauth_"
	 */
	public static final String PREFIX = "oauth_";

	/**
	 * "1.0"
	 */
	public static final String CURRENT_VERSION = "1.0";

	/**
	 * "oob"
	 */
	public static final String OOB = "oob";

	/**
	 * HMAC-SHA1
	 */
	public static final String HMACSHA1_SIGNATURE = "HMAC-SHA1";

	/**
	 * request token url
	 */
	public static final String OAUTH_REQUEST_TOKEN_URL = "reqTokenURL";

	/**
	 * authorization url
	 */
	public static final String OAUTH_AUTHORIZATION_URL = "authorizationURL";

	/**
	 * access token url
	 */
	public static final String OAUTH_ACCESS_TOKEN_URL = "accessTokenURL";

	/**
	 * token expires string
	 */
	public static final String EXPIRES = "expires";

	/**
	 * openid
	 */
	public static final String OPENID = "openid";

	/**
	 * facebook
	 */
	public static final String FACEBOOK = "facebook";

	/**
	 * foursquare
	 */
	public static final String FOURSQUARE = "foursquare";

	/**
	 * google
	 */
	public static final String GOOGLE = "google";

	/**
	 * hotmail
	 */
	public static final String HOTMAIL = "hotmail";

	/**
	 * linkedin
	 */
	public static final String LINKEDIN = "linkedin";

	/**
	 * myspace
	 */
	public static final String MYSPACE = "myspace";

	/**
	 * twitter
	 */
	public static final String TWITTER = "twitter";

	/**
	 * yahoo
	 */
	public static final String YAHOO = "yahoo";

	/**
	 * salesforce
	 */
	public static final String SALESFORCE = "salesforce";

	/**
	 * yammer
	 */
	public static final String YAMMER = "yammer";

	/**
	 * mendeley
	 */
	public static final String MENDELEY = "mendeley";

	/**
	 * access token parameter name
	 */
	public static final String ACCESS_TOKEN_PARAMETER_NAME = "access_token";

	/**
	 * Proxy host property name
	 */
	public static final String PROXY_HOST = "proxy.host";

	/**
	 * Proxy port property name
	 * 
	 */
	public static final String PROXY_PORT = "proxy.port";

	/**
	 * HTTP connection timeout property
	 */
	public static final String HTTP_CONNECTION_TIMEOUT = "http.connectionTimeOut";

	/**
	 * Content Encoding Header
	 */
	public static final String CONTENT_ENCODING_HEADER = "Content-Encoding";

	/**
	 * GZip Content Encoding
	 */
	public static final String GZIP_CONTENT_ENCODING = "gzip";
}
