/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.SocialAuthConfig;
import org.brickred.socialauth.exception.SocialAuthConfigurationException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.exception.SocialAuthManagerStateException;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.OAuthConfig;

public class SocialAuthManager
implements Serializable {
    private static final long serialVersionUID = 1620459182486095613L;
    private final Log LOG = LogFactory.getLog(SocialAuthManager.class);
    private AuthProvider authProvider;
    private String providerId;
    private String currentProviderId;
    private Map<String, AuthProvider> providersMap = new HashMap<String, AuthProvider>();
    private SocialAuthConfig socialAuthConfig;
    private Map<String, Permission> permissionsMap = new HashMap<String, Permission>();

    public SocialAuthConfig getSocialAuthConfig() {
        return this.socialAuthConfig;
    }

    public void setSocialAuthConfig(SocialAuthConfig socialAuthConfig) throws Exception {
        this.LOG.debug((Object)"Setting socialauth config");
        if (socialAuthConfig == null) {
            throw new SocialAuthConfigurationException("SocialAuthConfig is null");
        }
        if (!socialAuthConfig.isConfigSetup()) {
            throw new SocialAuthConfigurationException("Configuration is not provided. Call load() method of SocialAuthConfig class to set up configuration");
        }
        this.socialAuthConfig = socialAuthConfig;
    }

    public String getAuthenticationUrl(String id, String successUrl) throws Exception {
        this.LOG.debug((Object)("Getting Authentication URL for provider " + id + ", with success url : " + successUrl));
        return this.getAuthURL(id, successUrl, null);
    }

    public String getAuthenticationUrl(String id, String successUrl, Permission permission) throws Exception {
        this.LOG.debug((Object)("Getting Authentication URL for provider " + id + ", with success url : " + successUrl));
        return this.getAuthURL(id, successUrl, permission);
    }

    private String getAuthURL(String id, String successUrl, Permission permission) throws Exception {
        String url;
        this.providerId = id;
        if (this.socialAuthConfig == null) {
            throw new SocialAuthConfigurationException("SocialAuth configuration is null.");
        }
        if (this.providersMap.get(id) != null) {
            url = successUrl;
            this.authProvider = this.providersMap.get(id);
        } else {
            this.authProvider = this.getProviderInstance(id);
            if (this.permissionsMap.get(id) != null) {
                this.authProvider.setPermission(this.permissionsMap.get(id));
            }
            if (permission != null) {
                this.authProvider.setPermission(permission);
            }
            url = this.authProvider.getLoginRedirectURL(successUrl);
        }
        return url;
    }

    public AuthProvider connect(Map<String, String> requestParams) throws Exception {
        if (this.providerId == null || this.authProvider == null) {
            throw new SocialAuthManagerStateException();
        }
        this.LOG.info((Object)("Connecting provider : " + this.providerId));
        if (this.providersMap.get(this.providerId) == null) {
            this.authProvider.verifyResponse(requestParams);
            this.providersMap.put(this.providerId, this.authProvider);
        }
        this.currentProviderId = this.providerId;
        this.providerId = null;
        return this.authProvider;
    }

    public boolean disconnectProvider(String id) {
        if (this.providersMap.get(id) != null) {
            AuthProvider p = this.providersMap.get(id);
            p.logout();
            this.providersMap.remove(id);
            return true;
        }
        return false;
    }

    public AuthProvider connect(AccessGrant accessGrant) throws Exception {
        if (accessGrant.getProviderId() == null || accessGrant.getKey() == null) {
            throw new SocialAuthException("access grant is not valid");
        }
        this.LOG.debug((Object)("Connecting provider : " + accessGrant.getProviderId() + ", from given access grant"));
        AuthProvider provider = this.getProviderInstance(accessGrant.getProviderId());
        provider.setAccessGrant(accessGrant);
        this.authProvider = provider;
        this.currentProviderId = accessGrant.getProviderId();
        this.providersMap.put(this.currentProviderId, this.authProvider);
        return provider;
    }

    public boolean isConnected(String providerId) {
        return this.providersMap.containsKey(providerId);
    }

    public AuthProvider getProvider(String providerId) {
        return this.providersMap.get(providerId);
    }

    private AuthProvider getProviderInstance(String id) throws Exception {
        AuthProvider provider;
        OAuthConfig config = this.socialAuthConfig.getProviderConfig(id);
        Class<?> obj = config.getProviderImplClass();
        try {
            Constructor<?> cons = obj.getConstructor(OAuthConfig.class);
            provider = (AuthProvider)cons.newInstance(config);
        }
        catch (NoSuchMethodException me) {
            this.LOG.warn((Object)(obj.getName() + " does not implement a constructor " + obj.getName() + "(Poperties props)"));
            provider = (AuthProvider)obj.newInstance();
        }
        catch (Exception e) {
            throw new SocialAuthConfigurationException(e);
        }
        return provider;
    }

    public List<String> getConnectedProvidersIds() {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, AuthProvider> entry : this.providersMap.entrySet()) {
            list.add(entry.getKey());
        }
        return list;
    }

    public AuthProvider getCurrentAuthProvider() {
        if (this.currentProviderId != null) {
            return this.providersMap.get(this.currentProviderId);
        }
        return null;
    }

    public void setPermission(String providerId, Permission permission) {
        this.permissionsMap.put(providerId, permission);
    }
}

