/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.oauthstrategy;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.exception.ProviderStateException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.OAuthConsumer;
import org.brickred.socialauth.util.Response;

public class OAuth1
implements OAuthStrategyBase {
    private static final long serialVersionUID = -447820298609650347L;
    private final Log LOG = LogFactory.getLog(OAuth1.class);
    private AccessGrant accessToken;
    private AccessGrant requestToken;
    private OAuthConsumer oauth;
    private boolean providerState;
    private Map<String, String> endpoints;
    private String scope;
    private Permission permission;
    private String providerId;

    public OAuth1(OAuthConfig config, Map<String, String> endpoints) {
        this.oauth = new OAuthConsumer(config);
        this.endpoints = endpoints;
        this.permission = Permission.ALL;
        this.providerId = config.getId();
    }

    @Override
    public String getLoginRedirectURL(String successUrl) throws Exception {
        this.LOG.info((Object)"Determining URL for redirection");
        this.providerState = true;
        this.LOG.debug((Object)"Call to fetch Request Token");
        this.requestToken = this.oauth.getRequestToken(this.endpoints.get("reqTokenURL"), successUrl);
        String authUrl = this.endpoints.get("authorizationURL");
        if (this.scope != null) {
            authUrl = authUrl + this.scope;
        }
        StringBuilder urlBuffer = this.oauth.buildAuthUrl(authUrl, this.requestToken, successUrl);
        this.LOG.info((Object)("Redirection to following URL should happen : " + urlBuffer.toString()));
        return urlBuffer.toString();
    }

    @Override
    public AccessGrant verifyResponse(Map<String, String> requestParams, String methodType) throws Exception {
        this.LOG.info((Object)"Verifying the authentication response from provider");
        if (!this.providerState) {
            throw new ProviderStateException();
        }
        if (this.requestToken == null) {
            throw new SocialAuthException("Request token is null");
        }
        String verifier = requestParams.get("oauth_verifier");
        if (verifier != null) {
            this.requestToken.setAttribute("oauth_verifier", verifier);
        }
        this.LOG.debug((Object)"Call to fetch Access Token");
        this.accessToken = this.oauth.getAccessToken(this.endpoints.get("accessTokenURL"), this.requestToken);
        this.accessToken.setPermission(this.permission);
        this.accessToken.setProviderId(this.providerId);
        return this.accessToken;
    }

    @Override
    public AccessGrant verifyResponse(Map<String, String> requestParams) throws Exception {
        return this.verifyResponse(requestParams, MethodType.GET.toString());
    }

    @Override
    public void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    public void setPermission(Permission permission) {
        this.permission = permission;
    }

    @Override
    public Response executeFeed(String url) throws Exception {
        return this.oauth.httpGet(url, null, this.accessToken);
    }

    @Override
    public Response executeFeed(String urlStr, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        Response response = null;
        if (this.accessToken == null) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        if (MethodType.GET.toString().equals(methodType)) {
            try {
                response = this.oauth.httpGet(urlStr, headerParams, this.accessToken);
            }
            catch (Exception ie) {
                throw new SocialAuthException("Error while making request to URL : " + urlStr, ie);
            }
        }
        if (MethodType.PUT.toString().equals(methodType)) {
            try {
                response = this.oauth.httpPut(urlStr, params, headerParams, body, this.accessToken);
            }
            catch (Exception e) {
                throw new SocialAuthException("Error while making request to URL : " + urlStr, e);
            }
        }
        if (MethodType.POST.toString().equals(methodType)) {
            try {
                response = this.oauth.httpPost(urlStr, params, headerParams, body, this.accessToken);
                System.out.println(response.getStatus());
                System.out.println(response.getResponseBodyAsString("UTF-8"));
            }
            catch (Exception e) {
                throw new SocialAuthException("Error while making request to URL : " + urlStr, e);
            }
        }
        return response;
    }

    @Override
    public void setAccessGrant(AccessGrant accessGrant) {
        this.accessToken = accessGrant;
    }

    @Override
    public void setAccessTokenParameterName(String accessTokenParameterName) {
        this.LOG.warn((Object)"It is not implemented for OAuth1");
    }

    @Override
    public void logout() {
        this.accessToken = null;
        this.providerState = false;
    }
}

