/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.ServerDataException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.oauthstrategy.OAuth1;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.Response;
import org.brickred.socialauth.util.SocialAuthUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class MendeleyImpl
extends AbstractProvider
implements AuthProvider,
Serializable {
    private static final long serialVersionUID = -8791307959143391316L;
    private static final String PROFILE_URL = "https://api.mendeley.com/oapi/profiles/info/me/";
    private static final String CONTACTS_URL = "https://api.mendeley.com/oapi/profiles/contacts/";
    private static final Map<String, String> ENDPOINTS = new HashMap<String, String>();
    private final Log LOG = LogFactory.getLog(MendeleyImpl.class);
    private Permission scope;
    private boolean isVerify;
    private AccessGrant accessToken;
    private OAuthConfig config;
    private Profile userProfile;
    private OAuthStrategyBase authenticationStrategy;

    public MendeleyImpl(OAuthConfig providerConfig) throws Exception {
        this.config = providerConfig;
        this.authenticationStrategy = new OAuth1(this.config, ENDPOINTS);
    }

    @Override
    public void setAccessGrant(AccessGrant accessGrant) throws Exception {
        this.accessToken = accessGrant;
        this.isVerify = true;
        this.authenticationStrategy.setAccessGrant(accessGrant);
    }

    @Override
    public String getLoginRedirectURL(String successUrl) throws Exception {
        this.LOG.info((Object)"Determining URL for redirection");
        return this.authenticationStrategy.getLoginRedirectURL(successUrl);
    }

    @Override
    public Profile verifyResponse(HttpServletRequest request) throws Exception {
        Map<String, String> params = SocialAuthUtil.getRequestParametersMap(request);
        return this.doVerifyResponse(params);
    }

    @Override
    public Profile verifyResponse(Map<String, String> requestParams) throws Exception {
        return this.doVerifyResponse(requestParams);
    }

    private Profile doVerifyResponse(Map<String, String> requestParams) throws Exception {
        this.LOG.info((Object)"Verifying the authentication response from provider");
        this.accessToken = this.authenticationStrategy.verifyResponse(requestParams);
        this.isVerify = true;
        return this.getProfile();
    }

    private Profile getProfile() throws Exception {
        String result;
        Profile profile = new Profile();
        String url = PROFILE_URL;
        this.LOG.debug((Object)("Obtaining user profile. Profile URL : " + url));
        Response serviceResponse = null;
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(url);
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to retrieve the user profile from  " + url, e);
        }
        if (serviceResponse.getStatus() != 200) {
            throw new SocialAuthException("Failed to retrieve the user profile from  " + url + ". Staus :" + serviceResponse.getStatus());
        }
        try {
            result = serviceResponse.getResponseBodyAsString("UTF-8");
            this.LOG.debug((Object)("User Profile :" + result));
        }
        catch (Exception exc) {
            throw new SocialAuthException("Failed to read response from  " + url, exc);
        }
        try {
            String photo;
            String name;
            JSONObject pRes = new JSONObject(result);
            JSONObject pObj = pRes.getJSONObject("main");
            if (pObj.has("profile_id")) {
                profile.setValidatedId(pObj.getString("profile_id"));
            }
            if (pObj.has("name") && (name = pObj.getString("name")) != null && name.trim().length() > 0) {
                profile.setFirstName(pObj.getString("name"));
            }
            if (pObj.has("photo") && (photo = pObj.getString("photo")) != null && photo.trim().length() > 0) {
                profile.setProfileImageURL(pObj.getString("photo"));
            }
            profile.setProviderId(this.getProviderId());
            this.userProfile = profile;
            return profile;
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the user profile json : " + result, e);
        }
    }

    @Override
    public void updateStatus(String msg) throws Exception {
        throw new SocialAuthException("Mendeley does not support status updates");
    }

    @Override
    public List<Contact> getContactList() throws Exception {
        String result;
        if (!this.isVerify) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        String url = CONTACTS_URL;
        ArrayList<Contact> plist = new ArrayList<Contact>();
        this.LOG.info((Object)("Fetching contacts from " + url));
        Response serviceResponse = null;
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(url);
        }
        catch (Exception ie) {
            throw new SocialAuthException("Failed to retrieve the contacts from " + url, ie);
        }
        try {
            result = serviceResponse.getResponseBodyAsString("UTF-8");
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to get response from " + url);
        }
        try {
            this.LOG.debug((Object)("User Contacts list in json : " + result));
            JSONArray data = new JSONArray(result);
            this.LOG.debug((Object)("Found contacts : " + data.length()));
            for (int i = 0; i < data.length(); ++i) {
                JSONObject obj = data.getJSONObject(i);
                Contact p = new Contact();
                String name = obj.getString("name");
                if (name != null) {
                    String[] nameArr = name.split(" ");
                    if (nameArr.length > 1) {
                        p.setFirstName(nameArr[0]);
                        p.setLastName(nameArr[1]);
                    } else {
                        p.setFirstName(obj.getString("name"));
                    }
                    p.setDisplayName(name);
                }
                p.setId(obj.getString("profile_id"));
                plist.add(p);
            }
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the user friends json : " + result, e);
        }
        return plist;
    }

    @Override
    public void logout() {
        this.accessToken = null;
        this.authenticationStrategy.logout();
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested : " + p.toString()));
        this.scope = p;
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        if (!this.isVerify) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        Response response = null;
        this.LOG.debug((Object)("Calling URL : " + url));
        response = this.authenticationStrategy.executeFeed(url, methodType, params, headerParams, body);
        return response;
    }

    @Override
    public Profile getUserProfile() throws Exception {
        if (this.userProfile == null && this.accessToken != null) {
            this.getProfile();
        }
        return this.userProfile;
    }

    @Override
    public AccessGrant getAccessGrant() {
        return this.accessToken;
    }

    @Override
    public String getProviderId() {
        return this.config.getId();
    }

    static {
        ENDPOINTS.put("reqTokenURL", "https://www.mendeley.com/oauth/request_token/");
        ENDPOINTS.put("authorizationURL", "https://www.mendeley.com/oauth/authorize/");
        ENDPOINTS.put("accessTokenURL", "https://www.mendeley.com/oauth/access_token/");
    }
}

