/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.util;

import java.io.Serializable;
import org.brickred.socialauth.util.MethodType;

public class OAuthConfig
implements Serializable {
    private static final long serialVersionUID = 7574560869168900919L;
    private final String _consumerKey;
    private final String _consumerSecret;
    private final String _signatureMethod;
    private final String _transportName;
    private String id;
    private Class<?> providerImplClass;
    private String customPermissions;

    public OAuthConfig(String consumerKey, String consumerSecret, String signatureMethod, String transportName) {
        this._consumerKey = consumerKey;
        this._consumerSecret = consumerSecret;
        this._signatureMethod = signatureMethod == null || signatureMethod.length() == 0 ? "HMAC-SHA1" : signatureMethod;
        this._transportName = transportName == null || transportName.length() == 0 ? MethodType.GET.toString() : transportName;
    }

    public OAuthConfig(String consumerKey, String consumerSecret) {
        this._consumerKey = consumerKey;
        this._consumerSecret = consumerSecret;
        this._transportName = MethodType.GET.toString();
        this._signatureMethod = "HMAC-SHA1";
    }

    public String get_consumerKey() {
        return this._consumerKey;
    }

    public String get_consumerSecret() {
        return this._consumerSecret;
    }

    public String get_signatureMethod() {
        return this._signatureMethod;
    }

    public String get_transportName() {
        return this._transportName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Class<?> getProviderImplClass() {
        return this.providerImplClass;
    }

    public void setProviderImplClass(Class<?> providerImplClass) {
        this.providerImplClass = providerImplClass;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        result.append(this.getClass().getName() + " Object {" + NEW_LINE);
        result.append(" consumerKey: " + this._consumerKey + NEW_LINE);
        result.append(" consumerSecret: " + this._consumerSecret + NEW_LINE);
        result.append(" signatureMethod: " + this._signatureMethod + NEW_LINE);
        result.append(" transportName: " + this._transportName + NEW_LINE);
        result.append(" id: " + this.id + NEW_LINE);
        result.append(" providerImplClass: " + this.providerImplClass + NEW_LINE);
        result.append(" customPermissions: " + this.customPermissions + NEW_LINE);
        result.append("}");
        return result.toString();
    }

    public String getCustomPermissions() {
        return this.customPermissions;
    }

    public void setCustomPermissions(String customPermissions) {
        this.customPermissions = customPermissions;
    }
}

