/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.rdf;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.log4j.Logger;
import org.bridgedb.rdf.RdfBase;
import org.bridgedb.utils.BridgeDBException;
import org.bridgedb.utils.Reporter;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RDFWriterFactory;
import org.eclipse.rdf4j.rio.RDFWriterRegistry;

public class BridgeDbRdfTools {
    static final Logger logger = Logger.getLogger(BridgeDbRdfTools.class);
    public static final RDFFormat DEFAULT_FORMAT = RDFFormat.TRIX;

    public static String writeRDF(Set<Statement> statements, RDFFormat formatName) throws BridgeDBException {
        StringWriter writer = new StringWriter();
        if (formatName == null) {
            formatName = DEFAULT_FORMAT;
        }
        BridgeDbRdfTools.writeRDF(statements, formatName, writer);
        return writer.toString();
    }

    public static void writeRDF(Set<Statement> statements, RDFFormat format, Writer writer) throws BridgeDBException {
        RDFWriter rdfWriter = null;
        if (format != null) {
            rdfWriter = BridgeDbRdfTools.getWriterIfPossible(format, writer);
        }
        try {
            if (rdfWriter != null) {
                rdfWriter.startRDF();
                rdfWriter.handleNamespace("ops", RdfBase.DEFAULT_BASE_URI);
                rdfWriter.handleNamespace("void", "http://rdfs.org/ns/void#");
                rdfWriter.handleNamespace("dul", "http://www.ontologydesignpatterns.org/ont/dul/DUL.owl#");
                for (Statement statement : statements) {
                    rdfWriter.handleStatement(statement);
                }
                rdfWriter.endRDF();
            } else {
                writer.flush();
                writer.write("No Writer available for format: " + format + "\n");
            }
        }
        catch (RDFHandlerException ex) {
            throw new BridgeDBException("Error writing RDF. ", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new BridgeDBException("Error writing RDF. ", (Throwable)ex);
        }
    }

    public static Set<String> getAvaiableWriters() {
        Object n = null;
        Object nt = null;
        Object x2 = null;
        Object x = null;
        Object tr = null;
        Object tw = null;
        Object t = null;
        HashSet<String> results = new HashSet<String>();
        StringWriter writer = new StringWriter();
        ArrayList<RDFFormat> rdfFormats = new ArrayList<RDFFormat>();
        rdfFormats.add(RDFFormat.N3);
        rdfFormats.add(RDFFormat.NQUADS);
        rdfFormats.add(RDFFormat.NTRIPLES);
        rdfFormats.add(RDFFormat.JSONLD);
        rdfFormats.add(RDFFormat.RDFA);
        rdfFormats.add(RDFFormat.RDFJSON);
        rdfFormats.add(RDFFormat.RDFXML);
        rdfFormats.add(RDFFormat.TRIG);
        rdfFormats.add(RDFFormat.TRIX);
        rdfFormats.add(RDFFormat.TURTLE);
        for (RDFFormat rdfFormat : rdfFormats) {
            RDFWriter rdfWriter = BridgeDbRdfTools.getWriterIfPossible(rdfFormat, writer);
            if (rdfWriter == null) continue;
            results.add(rdfFormat.getName());
        }
        return results;
    }

    public static Set<RDFFormat> getAvaiableFormats() {
        HashSet<RDFFormat> results = new HashSet<RDFFormat>();
        StringWriter writer = new StringWriter();
        ArrayList<RDFFormat> rdfFormats = new ArrayList<RDFFormat>();
        rdfFormats.add(RDFFormat.N3);
        rdfFormats.add(RDFFormat.NQUADS);
        rdfFormats.add(RDFFormat.NTRIPLES);
        rdfFormats.add(RDFFormat.JSONLD);
        rdfFormats.add(RDFFormat.RDFA);
        rdfFormats.add(RDFFormat.RDFJSON);
        rdfFormats.add(RDFFormat.RDFXML);
        rdfFormats.add(RDFFormat.TRIG);
        rdfFormats.add(RDFFormat.TRIX);
        rdfFormats.add(RDFFormat.TURTLE);
        for (RDFFormat rdfFormat : rdfFormats) {
            RDFWriter rdfWriter = BridgeDbRdfTools.getWriterIfPossible(rdfFormat, writer);
            if (rdfWriter == null) continue;
            results.add(rdfFormat);
        }
        return results;
    }

    private static RDFWriter getWriterIfPossible(RDFFormat format, Writer writer) {
        RDFWriterRegistry register = RDFWriterRegistry.getInstance();
        Optional factory = register.get((Object)format);
        if (factory.get() == null) {
            return null;
        }
        try {
            return ((RDFWriterFactory)factory.get()).getWriter(writer);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return null;
        }
    }

    public static void main(String[] args) {
        Reporter.println((String)BridgeDbRdfTools.getAvaiableWriters().toString());
    }
}

